/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.File;
import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.inmemory.HashBasedIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;

class InMemoryIndex {
    protected final InMemoryIndexImplementation indexData;
    private InternalIndexState state = InternalIndexState.POPULATING;
    String failure;

    InMemoryIndex() {
        this(new HashBasedIndex());
    }

    InMemoryIndex(InMemoryIndexImplementation indexData) {
        this.indexData = indexData;
    }

    public String toString() {
        if (this.failure != null) {
            return String.format("%s[failure=\"%s\"]%s", this.getClass().getSimpleName(), this.failure, this.indexData);
        }
        return String.format("%s%s", this.getClass().getSimpleName(), this.indexData);
    }

    final IndexPopulator getPopulator() {
        return new Populator();
    }

    final IndexAccessor getOnlineAccessor() {
        return new OnlineAccessor();
    }

    protected final PrimitiveLongIterator lookup(Object propertyValue) {
        return this.indexData.lookup(propertyValue);
    }

    protected void add(long nodeId, Object propertyValue, boolean applyIdempotently) throws IndexEntryConflictException, IOException {
        this.indexData.add(nodeId, propertyValue, applyIdempotently);
    }

    protected void remove(long nodeId, Object propertyValue) {
        this.indexData.remove(nodeId, propertyValue);
    }

    protected void remove(long nodeId) {
        this.indexData.remove(nodeId);
    }

    InternalIndexState getState() {
        return this.state;
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws Exception {
    }

    protected IndexUpdater newUpdater(IndexUpdateMode mode, boolean populating) {
        return new InMemoryIndexUpdater(populating);
    }

    InMemoryIndex snapshot() {
        InMemoryIndex snapshot = new InMemoryIndex(this.indexData.snapshot());
        snapshot.failure = this.failure;
        snapshot.state = this.state;
        return snapshot;
    }

    private class InMemoryIndexUpdater
    implements IndexUpdater {
        private final boolean applyIdempotently;

        private InMemoryIndexUpdater(boolean applyIdempotently) {
            this.applyIdempotently = applyIdempotently;
        }

        public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
            switch (update.getUpdateMode()) {
                case ADDED: {
                    InMemoryIndex.this.add(update.getNodeId(), update.getValueAfter(), this.applyIdempotently);
                    break;
                }
                case CHANGED: {
                    InMemoryIndex.this.remove(update.getNodeId(), update.getValueBefore());
                    InMemoryIndex.this.add(update.getNodeId(), update.getValueAfter(), this.applyIdempotently);
                    break;
                }
                case REMOVED: {
                    InMemoryIndex.this.remove(update.getNodeId(), update.getValueBefore());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void close() throws IOException, IndexEntryConflictException {
        }

        public void remove(Iterable<Long> nodeIds) {
            for (Long nodeId : nodeIds) {
                InMemoryIndex.this.indexData.remove(nodeId);
            }
        }
    }

    private class OnlineAccessor
    implements IndexAccessor {
        private OnlineAccessor() {
        }

        public void force() throws IOException {
        }

        public void drop() throws IOException {
            InMemoryIndex.this.indexData.clear();
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return InMemoryIndex.this.newUpdater(mode, false);
        }

        public void close() throws IOException {
        }

        public IndexReader newReader() {
            return InMemoryIndex.this.indexData;
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            return InMemoryIndex.this.indexData;
        }

        public ResourceIterator<File> snapshotFiles() {
            return IteratorUtil.emptyIterator();
        }
    }

    private class Populator
    implements IndexPopulator {
        private Populator() {
        }

        public void create() {
            InMemoryIndex.this.indexData.clear();
        }

        public void add(long nodeId, Object propertyValue) throws IndexEntryConflictException, IOException {
            InMemoryIndex.this.add(nodeId, propertyValue, false);
        }

        public void verifyDeferredConstraints(PropertyAccessor accessor) throws Exception {
            InMemoryIndex.this.verifyDeferredConstraints(accessor);
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
            return InMemoryIndex.this.newUpdater(IndexUpdateMode.ONLINE, true);
        }

        public void drop() throws IOException {
            InMemoryIndex.this.indexData.clear();
        }

        public void close(boolean populationCompletedSuccessfully) throws IOException {
            if (populationCompletedSuccessfully) {
                InMemoryIndex.this.state = InternalIndexState.ONLINE;
            }
        }

        public void markAsFailed(String failureString) {
            InMemoryIndex.this.failure = failureString;
            InMemoryIndex.this.state = InternalIndexState.FAILED;
        }
    }
}

