/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class InMemoryIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String KEY = "in-memory";
    public static final SchemaIndexProvider.Descriptor PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
    private final InMemoryIndexProvider singleProvider;

    public InMemoryIndexProviderFactory() {
        super(KEY);
        this.singleProvider = null;
    }

    public InMemoryIndexProviderFactory(InMemoryIndexProvider singleProvider) {
        super(KEY);
        if (singleProvider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        this.singleProvider = singleProvider;
    }

    public Lifecycle newKernelExtension(Dependencies dependencies) throws Throwable {
        return this.hasSingleProvider() ? this.singleProvider : new InMemoryIndexProvider();
    }

    private boolean hasSingleProvider() {
        return this.singleProvider != null;
    }

    public static interface Dependencies {
    }
}

