/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class KernelIT
extends KernelIntegrationTest {
    @Test
    public void mixingBeansApiWithKernelAPI() throws Exception {
        Transaction beansAPITx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        beansAPITx.success();
        beansAPITx.finish();
    }

    @Test
    public void mixingBeansApiWithKernelAPIForNestedTransaction() throws Exception {
        Transaction outerTx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        outerTx.finish();
    }

    @Test
    public void changesInTransactionContextShouldBeRolledBackWhenTxIsRolledBack() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        try {
            statement.readOperations().nodeHasLabel(node.getId(), labelId);
            Assert.fail((String)"should have thrown exception");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        tx.finish();
    }

    @Test
    public void shouldNotBeAbleToCommitIfFailedTransactionContext() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("labello");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.failure();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        try {
            statement.readOperations().nodeHasLabel(node.getId(), labelId);
            Assert.fail((String)"should have thrown exception");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        tx.finish();
    }

    @Test
    public void transactionStateShouldRemovePreviouslyAddedLabel() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.dataWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{labelId1}), (Object)IteratorUtil.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId())));
        tx.finish();
    }

    @Test
    public void transactionStateShouldReflectRemovingAddedLabelImmediately() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.dataWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        Assert.assertFalse((boolean)statement.readOperations().nodeHasLabel(node.getId(), labelId2));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{labelId1}), (Object)IteratorUtil.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId())));
        statement.close();
        tx.success();
        tx.finish();
    }

    @Test
    public void transactionStateShouldReflectRemovingLabelImmediately() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        int labelId2 = statement.dataWriteOperations().labelGetOrCreateForName("labello2");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId2);
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId2);
        PrimitiveIntIterator labelsIterator = statement.readOperations().nodeGetLabels(node.getId());
        Set labels = IteratorUtil.asSet((PrimitiveIntIterator)labelsIterator);
        Assert.assertFalse((boolean)statement.readOperations().nodeHasLabel(node.getId(), labelId2));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{labelId1}), (Object)labels);
        statement.close();
        tx.success();
        tx.finish();
    }

    @Test
    public void labelShouldBeRemovedAfterCommit() throws Exception {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        Node node = this.db.createNode();
        int labelId1 = statement.dataWriteOperations().labelGetOrCreateForName("labello1");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId1);
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId1);
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        PrimitiveIntIterator labels = statement.readOperations().nodeGetLabels(node.getId());
        statement.close();
        tx.success();
        tx.finish();
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveIntIterator)labels), (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void addingNewLabelToNodeShouldRespondTrue() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextProvider.instance();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        boolean added = statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        Assert.assertFalse((String)"Shouldn't have been added now", (boolean)added);
        tx.finish();
    }

    @Test
    public void addingExistingLabelToNodeShouldRespondFalse() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextProvider.instance();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        boolean added = statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        Assert.assertTrue((String)"Should have been added now", (boolean)added);
        tx.finish();
    }

    @Test
    public void removingExistingLabelFromNodeShouldRespondTrue() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextProvider.instance();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.dataWriteOperations().nodeAddLabel(node.getId(), labelId);
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        boolean removed = statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId);
        Assert.assertTrue((String)"Should have been removed now", (boolean)removed);
        tx.finish();
    }

    @Test
    public void removingNonExistentLabelFromNodeShouldRespondFalse() throws Exception {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        Statement statement = this.statementContextProvider.instance();
        int labelId = statement.dataWriteOperations().labelGetOrCreateForName("mylabel");
        statement.close();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        statement = this.statementContextProvider.instance();
        boolean removed = statement.dataWriteOperations().nodeRemoveLabel(node.getId(), labelId);
        Assert.assertFalse((String)"Shouldn't have been removed now", (boolean)removed);
        tx.finish();
    }

    @Test
    public void deletingNodeWithLabelsShouldHaveThoseLabelRemovalsReflectedInTransaction() throws Exception {
        Transaction tx = this.db.beginTx();
        Label label = DynamicLabel.label((String)"labello");
        Node node = this.db.createNode(new Label[]{label});
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        statement.dataWriteOperations().nodeDelete(node.getId());
        int labelId = statement.readOperations().labelGetForName(label.name());
        Set labels = IteratorUtil.asSet((PrimitiveIntIterator)statement.readOperations().nodeGetLabels(node.getId()));
        boolean labelIsSet = statement.readOperations().nodeHasLabel(node.getId(), labelId);
        Set nodes = IteratorUtil.asSet((PrimitiveLongIterator)statement.readOperations().nodesGetForLabel(labelId));
        statement.close();
        tx.success();
        tx.finish();
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Long.class), (Object)nodes);
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Integer.class), (Object)labels);
        Assert.assertFalse((String)"Label should not be set on node here", (boolean)labelIsSet);
    }

    @Test
    public void deletingNodeWithLabelsShouldHaveRemovalReflectedInLabelScans() throws Exception {
        Transaction tx = this.db.beginTx();
        Label label = DynamicLabel.label((String)"labello");
        Node node = this.db.createNode(new Label[]{label});
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        node.delete();
        tx.success();
        tx.finish();
        tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        int labelId = statement.readOperations().labelGetForName(label.name());
        PrimitiveLongIterator nodes = statement.readOperations().nodesGetForLabel(labelId);
        Set nodeSet = IteratorUtil.asSet((PrimitiveLongIterator)nodes);
        tx.success();
        tx.finish();
        Assert.assertThat((Object)nodeSet, (Matcher)Matchers.equalTo(Collections.emptySet()));
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexComingOnline() throws Exception {
        this.schemaWriteOperationsInNewTransaction();
        this.getOrCreateSchemaState("my key", "my state");
        this.commit();
        this.createIndex(this.schemaWriteOperationsInNewTransaction());
        this.commit();
        this.schemaWriteOperationsInNewTransaction();
        this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
        this.commit();
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexDropped() throws Exception {
        IndexDescriptor idx = this.createIndex(this.schemaWriteOperationsInNewTransaction());
        this.commit();
        this.schemaWriteOperationsInNewTransaction();
        this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
        this.getOrCreateSchemaState("my key", "some state");
        this.commit();
        this.schemaWriteOperationsInNewTransaction().indexDrop(idx);
        this.commit();
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    private IndexDescriptor createIndex(SchemaWriteOperations schemaWriteOperations) throws SchemaKernelException {
        return schemaWriteOperations.indexCreate(schemaWriteOperations.labelGetOrCreateForName("hello"), schemaWriteOperations.propertyKeyGetOrCreateForName("hepp"));
    }

    private String getOrCreateSchemaState(String key, final String maybeSetThisState) {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        String state = (String)statement.readOperations().schemaStateGetOrCreate((Object)key, (Function)new Function<String, String>(){

            public String apply(String s) {
                return maybeSetThisState;
            }
        });
        tx.success();
        tx.finish();
        return state;
    }

    private boolean schemaStateContains(String key) {
        Transaction tx = this.db.beginTx();
        Statement statement = this.statementContextProvider.instance();
        final AtomicBoolean result = new AtomicBoolean(true);
        statement.readOperations().schemaStateGetOrCreate((Object)key, (Function)new Function<String, Object>(){

            public Object apply(String s) {
                result.set(false);
                return null;
            }
        });
        tx.success();
        tx.finish();
        return result.get();
    }
}

