/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.test.TestGraphDatabaseBuilder;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public abstract class KernelIntegrationTest {
    protected GraphDatabaseAPI db;
    protected ThreadToStatementContextBridge statementContextProvider;
    protected KernelAPI kernel;
    private Transaction beansTx;
    private Statement statement;
    private EphemeralFileSystemAbstraction fs;

    protected TokenWriteOperations tokenWriteOperationsInNewTransaction() throws KernelException {
        this.beansTx = this.db.beginTx();
        this.statement = this.statementContextProvider.instance();
        return this.statement.tokenWriteOperations();
    }

    protected DataWriteOperations dataWriteOperationsInNewTransaction() throws KernelException {
        this.beansTx = this.db.beginTx();
        this.statement = this.statementContextProvider.instance();
        return this.statement.dataWriteOperations();
    }

    protected SchemaWriteOperations schemaWriteOperationsInNewTransaction() throws KernelException {
        this.beansTx = this.db.beginTx();
        this.statement = this.statementContextProvider.instance();
        return this.statement.schemaWriteOperations();
    }

    protected ReadOperations readOperationsInNewTransaction() {
        this.beansTx = this.db.beginTx();
        this.statement = this.statementContextProvider.instance();
        return this.statement.readOperations();
    }

    protected void commit() {
        this.statement.close();
        this.statement = null;
        this.beansTx.success();
        this.beansTx.finish();
    }

    protected void rollback() {
        this.statement.close();
        this.statement = null;
        this.beansTx.failure();
        this.beansTx.finish();
    }

    @Before
    public void setup() {
        this.fs = new EphemeralFileSystemAbstraction();
        this.startDb("soft");
    }

    @After
    public void cleanup() throws Exception {
        this.stopDb();
        this.fs.shutdown();
    }

    protected void startDb(String cacheType) {
        TestGraphDatabaseBuilder graphDatabaseFactory = (TestGraphDatabaseBuilder)new TestGraphDatabaseFactory().setFileSystem(this.fs).newImpermanentDatabaseBuilder();
        this.db = (GraphDatabaseAPI)graphDatabaseFactory.setConfig(GraphDatabaseSettings.cache_type, cacheType).newGraphDatabase();
        this.statementContextProvider = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.kernel = (KernelAPI)this.db.getDependencyResolver().resolveDependency(KernelAPI.class);
    }

    protected void dbWithNoCache() {
        this.stopDb();
        this.startDb("none");
    }

    protected void stopDb() {
        if (this.beansTx != null) {
            this.beansTx.finish();
        }
        this.db.shutdown();
    }

    protected void restartDb() {
        this.stopDb();
        this.startDb("soft");
    }

    protected NeoStore neoStore() {
        return ((NeoStoreXaDataSource)((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getXaDataSource("nioneodb")).getNeoStore();
    }
}

