/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import javax.transaction.xa.XAException;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class TransactionHookIT
extends KernelIntegrationTest {
    @Test
    public void shouldRecieveTxStateOnCommit() throws Exception {
        TransactionHook hook = (TransactionHook)Mockito.mock(TransactionHook.class);
        this.kernel.registerTransactionHook(hook);
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        ops.nodeCreate();
        this.commit();
        ((TransactionHook)Mockito.verify((Object)hook)).beforeCommit((TxState)Mockito.any(TxState.class), (KernelTransaction)Mockito.any(KernelTransaction.class));
        ((TransactionHook)Mockito.verify((Object)hook)).afterCommit((TxState)Mockito.any(TxState.class), (KernelTransaction)Mockito.any(KernelTransaction.class), (TransactionHook.Outcome)Mockito.any(TransactionHook.Outcome.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{hook});
    }

    @Test
    public void shouldRollbackOnFailureInBeforeCommit() throws Exception {
        TransactionHook hook = (TransactionHook)Mockito.mock(TransactionHook.class);
        Mockito.when((Object)hook.beforeCommit((TxState)Mockito.any(TxState.class), (KernelTransaction)Mockito.any(KernelTransaction.class))).thenReturn((Object)new TransactionHook.Outcome(){

            public boolean isSuccessful() {
                return false;
            }

            public Throwable failure() {
                return new Throwable();
            }
        });
        this.kernel.registerTransactionHook(hook);
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        ops.nodeCreate();
        try {
            this.commit();
            TestCase.fail((String)"Expected this to fail.");
        }
        catch (TransactionFailureException e) {
            XAException xaException = (XAException)e.getCause().getCause();
            Assert.assertThat((Object)xaException.errorCode, (Matcher)Matchers.equalTo((Object)104));
            Assert.assertThat((Object)xaException.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Transaction handler failed."));
        }
        ((TransactionHook)Mockito.verify((Object)hook)).beforeCommit((TxState)Mockito.any(TxState.class), (KernelTransaction)Mockito.any(KernelTransaction.class));
        ((TransactionHook)Mockito.verify((Object)hook)).afterRollback((TxState)Mockito.any(TxState.class), (KernelTransaction)Mockito.any(KernelTransaction.class), (TransactionHook.Outcome)Mockito.any(TransactionHook.Outcome.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{hook});
    }
}

