/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.test.TargetDirectory;

public class UniquenessConstraintCreationIT
extends KernelIntegrationTest {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void shouldAbortConstraintCreationWhenDuplicatesExist() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        Node node = this.db.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
        long node1 = node.getId();
        node.setProperty("name", (Object)"foo");
        node = this.db.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
        long node2 = node.getId();
        node.setProperty("name", (Object)"foo");
        int foo = statement.labelGetForName("Foo");
        int name = statement.propertyKeyGetForName("name");
        this.commit();
        try {
            statement = this.schemaWriteOperationsInNewTransaction();
            statement.uniquenessConstraintCreate(foo, name);
            Assert.fail((String)"expected exception");
        }
        catch (CreateConstraintFailureException ex) {
            Assert.assertEquals((Object)new UniquenessConstraint(foo, name), (Object)ex.constraint());
            Throwable cause = ex.getCause();
            Assert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(ConstraintVerificationFailedKernelException.class));
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new ConstraintVerificationFailedKernelException.Evidence[]{new ConstraintVerificationFailedKernelException.Evidence((IndexEntryConflictException)new PreexistingIndexEntryConflictException((Object)"foo", node1, node2))}), (Object)((ConstraintVerificationFailedKernelException)cause).evidence());
        }
    }
}

