/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Function;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class UniquenessConstraintValidationConcurrencyIT {
    @Rule
    public final DatabaseRule database = new ImpermanentDatabaseRule();
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void shouldAllowConcurrentCreationOfNonConflictingData() throws Exception {
        this.database.executeAndCommit(UniquenessConstraintValidationConcurrencyIT.createUniquenessConstraint("Label1", "key1"));
        Future<Boolean> created = this.database.executeAndCommit(new Function<GraphDatabaseService, Future<Boolean>>(){

            public Future<Boolean> apply(GraphDatabaseService db) {
                db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                return UniquenessConstraintValidationConcurrencyIT.this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode(db, "Label1", "key1", "value2"));
            }
        });
        Assert.assertTrue((String)"Node creation should succeed", (boolean)created.get());
    }

    @Test
    public void shouldPreventConcurrentCreationOfConflictingData() throws Exception {
        this.database.executeAndCommit(UniquenessConstraintValidationConcurrencyIT.createUniquenessConstraint("Label1", "key1"));
        Future<Boolean> created = this.database.executeAndCommit(new Function<GraphDatabaseService, Future<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Future<Boolean> apply(GraphDatabaseService db) {
                db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                try {
                    Future<Boolean> future = UniquenessConstraintValidationConcurrencyIT.this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode(db, "Label1", "key1", "value1"));
                    return future;
                }
                finally {
                    Assert.assertThat(UniquenessConstraintValidationConcurrencyIT.this.otherThread, OtherThreadRule.isWaiting());
                }
            }
        });
        Assert.assertFalse((String)"node creation should fail", (boolean)created.get());
    }

    @Test
    public void shouldAllowOtherTransactionToCompleteIfFirstTransactionRollsBack() throws Exception {
        this.database.executeAndCommit(UniquenessConstraintValidationConcurrencyIT.createUniquenessConstraint("Label1", "key1"));
        Future<Boolean> created = this.database.executeAndRollback(new Function<GraphDatabaseService, Future<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Future<Boolean> apply(GraphDatabaseService db) {
                db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                try {
                    Future<Boolean> future = UniquenessConstraintValidationConcurrencyIT.this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode(db, "Label1", "key1", "value1"));
                    return future;
                }
                finally {
                    Assert.assertThat(UniquenessConstraintValidationConcurrencyIT.this.otherThread, OtherThreadRule.isWaiting());
                }
            }
        });
        Assert.assertTrue((String)"Node creation should succeed", (boolean)created.get());
    }

    private static Function<GraphDatabaseService, Void> createUniquenessConstraint(final String label, final String propertyKey) {
        return new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService db) {
                db.schema().constraintFor(DynamicLabel.label((String)label)).assertPropertyIsUnique(propertyKey).create();
                return null;
            }
        };
    }

    public static OtherThreadExecutor.WorkerCommand<Void, Boolean> createNode(final GraphDatabaseService db, final String label, final String propertyKey, final Object propertyValue) {
        return new OtherThreadExecutor.WorkerCommand<Void, Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doWork(Void nothing) throws Exception {
                Transaction tx = db.beginTx();
                try {
                    db.createNode(new Label[]{DynamicLabel.label((String)label)}).setProperty(propertyKey, propertyValue);
                    tx.success();
                    Boolean bl = true;
                    return bl;
                }
                catch (ConstraintViolationException e) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    tx.finish();
                }
            }
        };
    }
}

