/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.tooling.GlobalGraphOperations;

public class UniquenessConstraintValidationIT
extends KernelIntegrationTest {
    @Test
    public void shouldEnforceUniquenessConstraintOnSetProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        Node node = this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")});
        try {
            node.setProperty("key1", (Object)"value1");
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConstraintViolationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"\"key1\"=[value1]"));
        }
    }

    @Test
    public void shouldEnforceUniquenessConstraintOnAddLabel() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        Node node = this.db.createNode();
        node.setProperty("key1", (Object)"value1");
        try {
            node.addLabel(DynamicLabel.label((String)"Label1"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConstraintViolationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"\"key1\"=[value1]"));
        }
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
        Node node = this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        node.delete();
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        Node node = this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        node.removeLabel(DynamicLabel.label((String)"Label1"));
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
        Node node = this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        node.removeProperty("key1");
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
        Node node = this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        node.setProperty("key1", (Object)"value2");
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
        this.commit();
    }

    @Test
    public void shouldPreventConflictingDataInSameTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value2");
        try {
            this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value2");
            Assert.fail((String)"expected exception");
        }
        catch (ConstraintViolationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"\"key1\"=[value2]"));
        }
    }

    @Test
    public void shouldAllowNoopPropertyUpdate() throws KernelException {
        Node node = this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        node.setProperty("key1", (Object)"value1");
    }

    @Test
    public void shouldAllowNoopLabelUpdate() throws KernelException {
        Node node = this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        node.addLabel(DynamicLabel.label((String)"Label1"));
    }

    @Test
    public void shouldAllowCreationOfNonConflictingData() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        this.dataWriteOperationsInNewTransaction();
        this.db.createNode().setProperty("key1", (Object)"value1");
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label2")}).setProperty("key1", (Object)"value1");
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value2");
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key2", (Object)"value1");
        this.commit();
        this.dataWriteOperationsInNewTransaction();
        Assert.assertEquals((String)"number of nodes", (long)5L, (long)Iterables.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)this.db).getAllNodes()));
        this.rollback();
    }

    @Test
    public void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        this.createConstraint("Person", "id");
        this.dataWriteOperationsInNewTransaction();
        Node ourNode = this.db.createNode(new Label[]{DynamicLabel.label((String)"Person")});
        ourNode.setProperty("id", (Object)1);
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Item")}).setProperty("id", (Object)2);
        this.commit();
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        IndexDescriptor idx = statement.uniqueIndexGetForLabelAndPropertyKey(statement.labelGetForName("Person"), statement.propertyKeyGetForName("id"));
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Item")}).setProperty("id", (Object)2);
        Assert.assertThat((Object)statement.nodeGetUniqueFromIndexLookup(idx, (Object)1), (Matcher)Matchers.equalTo((Object)ourNode.getId()));
    }

    @Test
    public void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        this.createConstraint("Person", "id");
        this.dataWriteOperationsInNewTransaction();
        Node ourNode = this.db.createNode(new Label[]{DynamicLabel.label((String)"Person")});
        ourNode.setProperty("id", (Object)1);
        this.commit();
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        IndexDescriptor idx = statement.uniqueIndexGetForLabelAndPropertyKey(statement.labelGetForName("Person"), statement.propertyKeyGetForName("id"));
        this.db.createNode(new Label[]{DynamicLabel.label((String)"Person")}).setProperty("id", (Object)2);
        Assert.assertThat((Object)statement.nodeGetUniqueFromIndexLookup(idx, (Object)1), (Matcher)Matchers.equalTo((Object)ourNode.getId()));
    }

    private Node constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
        this.dataWriteOperationsInNewTransaction();
        Node node = this.db.createNode(new Label[]{DynamicLabel.label((String)labelName)});
        node.setProperty(propertyKey, propertyValue);
        this.commit();
        this.createConstraint(labelName, propertyKey);
        return node;
    }

    private void createConstraint(String label, String propertyKey) throws KernelException {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int labelId = statement.labelGetOrCreateForName(label);
        int propertyKeyId = statement.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(labelId, propertyKeyId);
        this.commit();
    }
}

