/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.operations;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ConstraintEnforcingEntityOperationsTest {
    private final int labelId = 1;
    private final int propertyKeyId = 2;
    private final String value = "value";
    private final IndexDescriptor indexDescriptor = new IndexDescriptor(1, 2);
    private EntityReadOperations readOps;
    private SchemaReadOperations schemaOps;
    private KernelStatement state;
    private Locks.Client locks;
    private ConstraintEnforcingEntityOperations ops;

    @Before
    public void given_ConstraintEnforcingEntityOperations_with_OnlineIndex() throws Exception {
        this.readOps = (EntityReadOperations)Mockito.mock(EntityReadOperations.class);
        this.schemaOps = (SchemaReadOperations)Mockito.mock(SchemaReadOperations.class);
        this.state = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)this.schemaOps.indexGetState(this.state, this.indexDescriptor)).thenReturn((Object)InternalIndexState.ONLINE);
        this.locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)this.state.locks()).thenReturn((Object)this.locks);
        this.ops = new ConstraintEnforcingEntityOperations(null, this.readOps, this.schemaOps);
    }

    @Test
    public void shouldHoldIndexReadLockIfNodeIsExists() throws Exception {
        long expectedNodeId = 15L;
        Mockito.when((Object)this.readOps.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)"value")).thenReturn((Object)expectedNodeId);
        long nodeId = this.ops.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)"value");
        Assert.assertEquals((long)expectedNodeId, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    @Test
    public void shouldHoldIndexWriteLockIfNodeDoesNotExist() throws Exception {
        Mockito.when((Object)this.readOps.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)"value")).thenReturn((Object)-1L);
        long nodeId = this.ops.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)"value");
        Assert.assertEquals((long)-1L, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        ((Locks.Client)Mockito.verify((Object)this.locks)).releaseShared((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    @Test
    public void shouldHoldIndexReadLockIfNodeIsConcurrentlyCreated() throws Exception {
        long expectedNodeId = 15L;
        Mockito.when((Object)this.readOps.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)"value")).thenReturn((Object)-1L).thenReturn((Object)expectedNodeId);
        long nodeId = this.ops.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)"value");
        Assert.assertEquals((long)expectedNodeId, (long)nodeId);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireShared((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        ((Locks.Client)Mockito.verify((Object)this.locks)).releaseShared((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        ((Locks.Client)Mockito.verify((Object)this.locks)).releaseExclusive((Locks.ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceTypes.indexEntryResourceId((long)1L, (long)2L, (String)"value")});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }
}

