/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Neo4jMockitoHelpers;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.DiffSets;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;

public class IndexQueryTransactionStateTest {
    int labelId = 2;
    int propertyKeyId = 3;
    String value = "My Value";
    IndexDescriptor indexDescriptor = new IndexDescriptor(this.labelId, this.propertyKeyId);
    private StoreReadLayer store;
    private OldTxStateBridge oldTxState;
    private EntityOperations txContext;
    private KernelStatement state;

    @Test
    public void shouldExcludeRemovedNodesFromIndexQuery() throws Exception {
        Mockito.when((Object)this.store.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(1L, 2L, 3L)));
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets());
        Mockito.when((Object)this.oldTxState.hasChanges()).thenReturn((Object)true);
        this.txContext.nodeDelete(this.state, 2L);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{1L, 3L})));
    }

    @Test
    public void shouldExcludeRemovedNodeFromUniqueIndexQuery() throws Exception {
        Mockito.when((Object)this.store.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(1L));
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets());
        Mockito.when((Object)this.oldTxState.hasChanges()).thenReturn((Object)true);
        this.txContext.nodeDelete(this.state, 1L);
        long result = this.txContext.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldExcludeChangedNodesWithMissingLabelFromIndexQuery() throws Exception {
        Mockito.when((Object)this.store.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)false);
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets(IteratorUtil.asSet((Object[])new Long[]{1L}), Collections.emptySet()));
        Mockito.when((Object)this.oldTxState.hasChanges()).thenReturn((Object)true);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeChangedNodeWithMissingLabelFromUniqueIndexQuery() throws Exception {
        Mockito.when((Object)this.store.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)false);
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets(IteratorUtil.asSet((Object[])new Long[]{1L}), Collections.emptySet()));
        Mockito.when((Object)this.oldTxState.hasChanges()).thenReturn((Object)true);
        long result = this.txContext.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldIncludeCreatedNodesWithCorrectLabelAndProperty() throws Exception {
        Mockito.when((Object)this.store.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        Mockito.when((Object)this.store.nodeGetProperty(org.mockito.Matchers.anyLong(), org.mockito.Matchers.eq((int)this.propertyKeyId))).thenReturn((Object)Property.noNodeProperty((long)1L, (int)this.propertyKeyId));
        Mockito.when((Object)this.store.nodeGetAllProperties(org.mockito.Matchers.anyLong())).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)false);
        this.state.txState().nodeDoReplaceProperty(1L, Property.noNodeProperty((long)1L, (int)this.propertyKeyId), Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        this.txContext.nodeAddLabel(this.state, 1L, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{1L, 2L, 3L})));
    }

    @Test
    public void shouldIncludeUniqueCreatedNodeWithCorrectLabelAndProperty() throws Exception {
        Mockito.when((Object)this.store.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        Mockito.when((Object)this.store.nodeGetProperty(org.mockito.Matchers.anyLong(), org.mockito.Matchers.eq((int)this.propertyKeyId))).thenReturn((Object)Property.noNodeProperty((long)1L, (int)this.propertyKeyId));
        Mockito.when((Object)this.store.nodeGetAllProperties(org.mockito.Matchers.anyLong())).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)false);
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets(IteratorUtil.asSet((Object[])new Long[]{1L}), Collections.emptySet()));
        this.state.txState().nodeDoReplaceProperty(1L, Property.noNodeProperty((long)1L, (int)this.propertyKeyId), Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        this.txContext.nodeAddLabel(this.state, 1L, this.labelId);
        long result = this.txContext.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void shouldIncludeExistingNodesWithCorrectPropertyAfterAddingLabel() throws Exception {
        Mockito.when((Object)this.store.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)false);
        DefinedProperty stringProperty = Property.stringProperty((int)this.propertyKeyId, (String)this.value);
        Mockito.when((Object)this.store.nodeGetProperty(1L, this.propertyKeyId)).thenReturn((Object)stringProperty);
        Mockito.when((Object)this.store.nodeGetAllProperties(org.mockito.Matchers.anyLong())).thenReturn((Object)IteratorUtil.iterator((Object)stringProperty));
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets());
        this.txContext.nodeAddLabel(this.state, 1L, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{1L, 2L, 3L})));
    }

    @Test
    public void shouldIncludeExistingUniqueNodeWithCorrectPropertyAfterAddingLabel() throws Exception {
        Mockito.when((Object)this.store.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        Mockito.when((Object)this.store.nodeHasLabel(2L, this.labelId)).thenReturn((Object)false);
        DefinedProperty stringProperty = Property.stringProperty((int)this.propertyKeyId, (String)this.value);
        Mockito.when((Object)this.store.nodeGetProperty(2L, this.propertyKeyId)).thenReturn((Object)stringProperty);
        Mockito.when((Object)this.store.nodeGetAllProperties(org.mockito.Matchers.anyLong())).thenReturn((Object)IteratorUtil.iterator((Object)stringProperty));
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets());
        this.txContext.nodeAddLabel(this.state, 2L, this.labelId);
        long result = this.txContext.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)2L));
    }

    @Test
    public void shouldExcludeExistingNodesWithCorrectPropertyAfterRemovingLabel() throws Exception {
        Mockito.when((Object)this.store.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(1L, 2L, 3L)));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)true);
        DefinedProperty stringProperty = Property.stringProperty((int)this.propertyKeyId, (String)this.value);
        Mockito.when((Object)this.store.nodeGetProperty(1L, this.propertyKeyId)).thenReturn((Object)stringProperty);
        Mockito.when((Object)this.store.nodeGetAllProperties(org.mockito.Matchers.anyLong())).thenReturn((Object)IteratorUtil.iterator((Object)stringProperty));
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets());
        this.txContext.nodeRemoveLabel(this.state, 1L, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeExistingUniqueNodeWithCorrectPropertyAfterRemovingLabel() throws Exception {
        Mockito.when((Object)this.store.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(1L));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)true);
        DefinedProperty stringProperty = Property.stringProperty((int)this.propertyKeyId, (String)this.value);
        Mockito.when((Object)this.store.nodeGetProperty(1L, this.propertyKeyId)).thenReturn((Object)stringProperty);
        Mockito.when((Object)this.store.nodeGetAllProperties(org.mockito.Matchers.anyLong())).thenReturn((Object)IteratorUtil.iterator((Object)stringProperty));
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets());
        this.txContext.nodeRemoveLabel(this.state, 1L, this.labelId);
        long result = this.txContext.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldExcludeNodesWithRemovedProperty() throws Exception {
        Mockito.when((Object)this.store.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)true);
        Mockito.when((Object)this.oldTxState.getNodesWithChangedProperty(this.propertyKeyId, (Object)this.value)).thenReturn((Object)new DiffSets(Collections.emptySet(), IteratorUtil.asSet((Object[])new Long[]{1L})));
        this.txContext.nodeAddLabel(this.state, 1L, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)IteratorUtil.asSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeUniqueNodeWithRemovedProperty() throws Exception {
        Mockito.when((Object)this.store.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(1L));
        Mockito.when((Object)this.store.nodeGetProperty(1L, this.propertyKeyId)).thenReturn((Object)Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        Mockito.when((Object)this.store.nodeHasLabel(1L, this.labelId)).thenReturn((Object)true);
        Mockito.when((Object)this.store.nodeGetLabels(1L)).thenReturn((Object)PrimitiveIntCollections.iterator((int[])new int[]{this.labelId}));
        this.txContext.nodeRemoveProperty(this.state, 1L, this.propertyKeyId);
        long result = this.txContext.nodeGetUniqueFromIndexLookup(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Before
    public void before() throws Exception {
        this.oldTxState = (OldTxStateBridge)Mockito.mock(OldTxStateBridge.class);
        TxStateImpl txState = new TxStateImpl(this.oldTxState, (PersistenceManager)Mockito.mock(PersistenceManager.class), (TxState.IdGeneration)Mockito.mock(TxState.IdGeneration.class));
        this.state = StatementOperationsTestHelper.mockedState((TxState)txState);
        int labelId1 = 10;
        int labelId2 = 12;
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexGetState(this.indexDescriptor)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.store.indexesGetForLabel(labelId1)).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetForLabel(labelId2)).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetAll()).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.constraintsGetForLabel(this.labelId)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.store.indexesGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId)).thenReturn((Object)new IndexDescriptor(this.labelId, this.propertyKeyId));
        StateHandlingStatementOperations stateHandlingOperations = new StateHandlingStatementOperations(this.store, (LegacyPropertyTrackers)Mockito.mock(LegacyPropertyTrackers.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class));
        this.txContext = new ConstraintEnforcingEntityOperations((EntityWriteOperations)stateHandlingOperations, (EntityReadOperations)stateHandlingOperations, (SchemaReadOperations)stateHandlingOperations);
    }

    private void assertNoSuchNode(long node) {
        Assert.assertThat((Object)node, (Matcher)Matchers.equalTo((Object)-1L));
    }

    private static PrimitiveLongResourceIterator asPrimitiveResourceIterator(long ... values) {
        return IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])values), (Resource)new Resource(){

            public void close() {
            }
        });
    }
}

