/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.state.OldTxStateBridgeImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.util.DiffSets;

public class OldTxStateBridgeImplTest {
    @Test
    public void shouldListNodesWithPropertyAdded() throws Exception {
        long nodeId = 1L;
        int propertyKey = 2;
        int value = 1337;
        WritableTransactionState state = new WritableTransactionState(null, null, null, null);
        OldTxStateBridgeImpl bridge = new OldTxStateBridgeImpl(null, (TransactionState)state);
        NodeImpl node = new NodeImpl(nodeId);
        state.getOrCreateCowPropertyAddMap((Primitive)node).put((Object)2, (Object)Property.intProperty((int)propertyKey, (int)value));
        DiffSets nodes = bridge.getNodesWithChangedProperty(propertyKey, (Object)value);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId}), (Object)nodes.getAdded());
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Long.class), (Object)nodes.getRemoved());
    }

    @Test
    public void shouldListNodesWithPropertyRemoved() throws Exception {
        long nodeId = 1L;
        int propertyKey = 2;
        int value = 1337;
        WritableTransactionState state = new WritableTransactionState(null, null, null, null);
        OldTxStateBridgeImpl bridge = new OldTxStateBridgeImpl(null, (TransactionState)state);
        NodeImpl node = new NodeImpl(nodeId);
        state.getOrCreateCowPropertyRemoveMap((Primitive)node).put((Object)2, (Object)Property.intProperty((int)propertyKey, (int)value));
        DiffSets nodes = bridge.getNodesWithChangedProperty(propertyKey, (Object)value);
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Long.class), (Object)nodes.getAdded());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId}), (Object)nodes.getRemoved());
    }

    @Test
    public void shouldListNodesWithPropertyChanged() throws Exception {
        long nodeId = 1L;
        int propertyKey = 2;
        int value = 1337;
        WritableTransactionState state = new WritableTransactionState(null, null, null, null);
        OldTxStateBridgeImpl bridge = new OldTxStateBridgeImpl(null, (TransactionState)state);
        NodeImpl node = new NodeImpl(nodeId);
        state.getOrCreateCowPropertyAddMap((Primitive)node).put((Object)2, (Object)Property.intProperty((int)propertyKey, (int)7331));
        DiffSets nodes = bridge.getNodesWithChangedProperty(propertyKey, (Object)value);
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(Long.class), (Object)nodes.getAdded());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId}), (Object)nodes.getRemoved());
    }
}

