/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.DiffSets;

public class StateHandlingStatementOperationsTest {
    StoreReadLayer inner = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);

    @Test
    public void shouldNeverDelegateWrites() throws Exception {
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        Mockito.when((Object)this.inner.nodeGetAllProperties(Matchers.anyLong())).thenReturn((Object)IteratorUtil.emptyIterator());
        StateHandlingStatementOperations ctx = this.newTxStateOps(this.inner);
        ctx.indexCreate(state, 0, 0);
        ctx.nodeAddLabel(state, 0L, 0);
        ctx.indexDrop(state, new IndexDescriptor(0, 0));
        ctx.nodeRemoveLabel(state, 0L, 0);
        ((StoreReadLayer)Mockito.verify((Object)this.inner, (VerificationMode)Mockito.times((int)1))).nodeGetAllProperties(0L);
        ((StoreReadLayer)Mockito.verify((Object)this.inner, (VerificationMode)Mockito.times((int)2))).nodeHasLabel(0L, 0);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldNotAddConstraintAlreadyExistsInTheStore() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(10, 66);
        TxState txState = (TxState)Mockito.mock(TxState.class);
        Mockito.when((Object)txState.nodesWithLabelChanged(Matchers.anyInt())).thenReturn((Object)DiffSets.emptyDiffSets());
        KernelStatement state = StatementOperationsTestHelper.mockedState(txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Arrays.asList(constraint)));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquenessConstraintCreate(state, 10, 66);
        ((TxState)Mockito.verify((Object)txState)).constraintIndexDoUnRemove((IndexDescriptor)Matchers.any(IndexDescriptor.class));
    }

    @Test
    public void shouldGetConstraintsByLabelAndProperty() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(10, 66);
        TxStateImpl txState = new TxStateImpl((OldTxStateBridge)Mockito.mock(OldTxStateBridge.class), (PersistenceManager)Mockito.mock(PersistenceManager.class), (TxState.IdGeneration)Mockito.mock(TxState.IdGeneration.class));
        KernelStatement state = StatementOperationsTestHelper.mockedState((TxState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquenessConstraintCreate(state, 10, 66);
        Set result = IteratorUtil.asSet((Iterable)IteratorUtil.asIterable((Iterator)context.constraintsGetForLabelAndPropertyKey(state, 10, 66)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{constraint}), (Object)result);
    }

    @Test
    public void shouldGetConstraintsByLabel() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(11, 66);
        UniquenessConstraint constraint2 = new UniquenessConstraint(11, 99);
        TxStateImpl txState = new TxStateImpl((OldTxStateBridge)Mockito.mock(OldTxStateBridge.class), (PersistenceManager)Mockito.mock(PersistenceManager.class), (TxState.IdGeneration)Mockito.mock(TxState.IdGeneration.class));
        KernelStatement state = StatementOperationsTestHelper.mockedState((TxState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(11, 99)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabel(10)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabel(11)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(IteratorUtil.asIterable((Object[])new UniquenessConstraint[]{constraint1})));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquenessConstraintCreate(state, 10, 66);
        context.uniquenessConstraintCreate(state, 11, 99);
        Set result = IteratorUtil.asSet((Iterable)IteratorUtil.asIterable((Iterator)context.constraintsGetForLabel(state, 11)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{constraint1, constraint2}), (Object)result);
    }

    @Test
    public void shouldGetAllConstraints() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(10, 66);
        UniquenessConstraint constraint2 = new UniquenessConstraint(11, 99);
        TxStateImpl txState = new TxStateImpl((OldTxStateBridge)Mockito.mock(OldTxStateBridge.class), (PersistenceManager)Mockito.mock(PersistenceManager.class), (TxState.IdGeneration)Mockito.mock(TxState.IdGeneration.class));
        KernelStatement state = StatementOperationsTestHelper.mockedState((TxState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(11, 99)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetAll()).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(IteratorUtil.asIterable((Object[])new UniquenessConstraint[]{constraint2})));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquenessConstraintCreate(state, 10, 66);
        Set result = IteratorUtil.asSet((Iterable)IteratorUtil.asIterable((Iterator)context.constraintsGetAll(state)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{constraint1, constraint2}), (Object)result);
    }

    private static <T> Answer<Iterator<T>> asAnswer(final Iterable<T> values) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocation) throws Throwable {
                return values.iterator();
            }
        };
    }

    private StateHandlingStatementOperations newTxStateOps(StoreReadLayer delegate) {
        return new StateHandlingStatementOperations(delegate, (LegacyPropertyTrackers)Mockito.mock(LegacyPropertyTrackers.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class));
    }
}

