/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.DiffSets;
import org.neo4j.kernel.impl.util.PrimitiveIteratorMatchers;

public class TxStateTest {
    private PersistenceManager persistenceManager;
    private TxState state;
    private OldTxStateBridge legacyState;
    private final Set<Long> emptySet = Collections.emptySet();

    @Test
    public void shouldGetAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        Set addedLabels = this.state.nodeStateLabelDiffSets(1L).getAdded();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), (Object)addedLabels);
    }

    @Test
    public void shouldGetRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        Set removedLabels = this.state.nodeStateLabelDiffSets(1L).getRemoved();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), (Object)removedLabels);
    }

    @Test
    public void removeAddedLabelShouldRemoveFromAdded() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        this.state.nodeDoRemoveLabel(1, 1L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getAdded());
    }

    @Test
    public void addRemovedLabelShouldRemoveFromRemoved() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        this.state.nodeDoAddLabel(1, 1L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getRemoved());
    }

    @Test
    public void shouldMapFromAddedLabelToNodes() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(2, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(3, 1L);
        this.state.nodeDoAddLabel(2, 2L);
        Set nodes = this.state.nodesWithLabelAdded(2);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{0L, 2L}), (Object)IteratorUtil.asSet((Iterable)nodes));
    }

    @Test
    public void shouldMapFromRemovedLabelToNodes() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(2, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(3, 1L);
        this.state.nodeDoRemoveLabel(2, 2L);
        Set nodes = this.state.nodesWithLabelChanged(2).getRemoved();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{0L, 2L}), (Object)IteratorUtil.asSet((Iterable)nodes));
    }

    @Test
    public void shouldAddAndGetByLabel() throws Exception {
        int labelId = 2;
        int labelId2 = 5;
        int propertyKey = 3;
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        this.state.indexRuleDoAdd(rule);
        this.state.indexRuleDoAdd(new IndexDescriptor(labelId2, propertyKey));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule}), (Object)this.state.indexDiffSetsByLabel(labelId).getAdded());
    }

    @Test
    public void shouldAddAndGetByRuleId() throws Exception {
        int labelId = 2;
        int propertyKey = 3;
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        this.state.indexRuleDoAdd(rule);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule}), (Object)this.state.indexChanges().getAdded());
    }

    @Test
    public void shouldIncludeAddedNodesWithCorrectProperty() throws Exception {
        long nodeId = 1337L;
        int propertyKey = 2;
        String propValue = "hello";
        this.state.nodeDoReplaceProperty(nodeId, Property.noNodeProperty((long)nodeId, (int)propertyKey), Property.stringProperty((int)propertyKey, (String)propValue));
        DiffSets diff = this.state.nodesWithChangedProperty(propertyKey, (Object)propValue);
        Assert.assertThat((Object)diff.getAdded(), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
        Assert.assertThat((Object)diff.getRemoved(), (Matcher)IsEqual.equalTo(this.emptySet));
    }

    @Test
    public void shouldExcludeNodesWithCorrectPropertyRemoved() throws Exception {
        long nodeId = 1337L;
        int propertyKey = 2;
        String propValue = "hello";
        this.state.nodeDoRemoveProperty(nodeId, Property.stringProperty((int)propertyKey, (String)propValue));
        DiffSets diff = this.state.nodesWithChangedProperty(propertyKey, (Object)propValue);
        Assert.assertThat((Object)diff.getAdded(), (Matcher)IsEqual.equalTo(this.emptySet));
        Assert.assertThat((Object)diff.getRemoved(), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
    }

    @Test
    public void shouldListNodeAsDeletedIfItIsDeleted() throws Exception {
        long nodeId = 1337L;
        this.state.nodeDoDelete(nodeId);
        ((OldTxStateBridge)Mockito.verify((Object)this.legacyState)).deleteNode(nodeId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.legacyState, this.persistenceManager});
        Assert.assertThat((Object)IteratorUtil.asSet((Iterable)this.state.addedAndRemovedNodes().getRemoved()), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
    }

    @Test
    public void shouldAddUniquenessConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint, 7L);
        DiffSets diff = this.state.constraintsChangesForLabel(1);
        Assert.assertEquals(Collections.singleton(constraint), (Object)diff.getAdded());
        Assert.assertTrue((boolean)diff.getRemoved().isEmpty());
    }

    @Test
    public void addingUniquenessConstraintShouldBeIdempotent() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint1, 7L);
        UniquenessConstraint constraint2 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint2, 19L);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
    }

    @Test
    public void shouldDifferentiateBetweenUniquenessConstraintsForDifferentLabels() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint1, 7L);
        UniquenessConstraint constraint2 = new UniquenessConstraint(2, 17);
        this.state.constraintDoAdd(constraint2, 19L);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForLabel(2).getAdded());
    }

    @Test
    public void shouldListRelationshipsAsCreatedIfCreated() throws Exception {
        long relId = this.state.relationshipDoCreate(0, 1L, 2L);
        Mockito.when((Object)this.legacyState.relationshipIsAddedInThisTx(relId)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertTrue((boolean)this.state.relationshipIsAddedInThisTx(relId));
    }

    @Test
    public void shouldAugmentWithAddedRelationships() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relId = this.state.relationshipDoCreate(relType, (long)startNode, (long)endNode);
        long otherRel = relId + 1L;
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.OUTGOING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.INCOMING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
    }

    @Test
    public void addedAndThenRemovedRelShouldNotShowUp() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relId = this.state.relationshipDoCreate(relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relId, (long)startNode, (long)endNode, relType);
        long otherRel = relId + 1L;
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.OUTGOING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.INCOMING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
    }

    @Test
    public void shouldGiveCorrectDegreeWhenAddingAndRemovingRelationships() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        this.state.relationshipDoCreate(relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relType + 1, (long)endNode, (long)startNode);
        this.state.relationshipDoDelete(1337L, (long)startNode, (long)endNode, relType);
        this.state.relationshipDoDelete(1338L, (long)startNode, (long)startNode, relType + 1);
        Assert.assertEquals((long)12L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH));
        Assert.assertEquals((long)10L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.INCOMING));
        Assert.assertEquals((long)11L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH, relType));
    }

    @Test
    public void shouldGiveCorrectRelationshipTypesForNode() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relA = this.state.relationshipDoCreate(relType, (long)startNode, (long)endNode);
        long relB = this.state.relationshipDoCreate(relType, (long)startNode, (long)endNode);
        long relC = this.state.relationshipDoCreate(relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relB, (long)startNode, (long)endNode, relType);
        this.state.relationshipDoDelete(relC, (long)startNode, (long)endNode, relType + 1);
        Assert.assertThat((Object)IteratorUtil.asList((PrimitiveIntIterator)this.state.nodeRelationshipTypes((long)startNode)), (Matcher)IsEqual.equalTo(Arrays.asList(relType)));
    }

    @Before
    public void before() throws Exception {
        this.legacyState = (OldTxStateBridge)Mockito.mock(OldTxStateBridge.class);
        Mockito.when((Object)this.legacyState.relationshipCreate(Matchers.anyInt(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L});
        this.persistenceManager = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        this.state = new TxStateImpl(this.legacyState, this.persistenceManager, (TxState.IdGeneration)Mockito.mock(TxState.IdGeneration.class));
    }
}

