/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;

public class HeuristicsTestSupport {
    public static StoreReadLayer generateStore() throws EntityNotFoundException {
        return HeuristicsTestSupport.generateStore(1.0);
    }

    public static StoreReadLayer generateStore(double liveNodes) throws EntityNotFoundException {
        StoreReadLayer store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)store.highestNodeIdInUse()).thenReturn((Object)1000L);
        HeuristicsTestSupport.mockNodeLiveness(liveNodes, store);
        Mockito.when((Object)store.nodeGetLabels(Matchers.anyLong())).then(HeuristicsTestSupport.answerWithDistribution(20, HeuristicsTestSupport.ids(0), 80, HeuristicsTestSupport.ids(1)));
        Mockito.when((Object)store.nodeGetRelationshipTypes(Matchers.anyLong())).then(HeuristicsTestSupport.answerWithDistribution(40, HeuristicsTestSupport.ids(0), 60, HeuristicsTestSupport.ids(1)));
        Mockito.when((Object)store.nodeGetDegree(Matchers.anyLong(), (Direction)Matchers.eq((Object)Direction.INCOMING), Matchers.anyInt())).then(HeuristicsTestSupport.answerWithDistribution(10, HeuristicsTestSupport.degree(10), 30, HeuristicsTestSupport.degree(40), 90, HeuristicsTestSupport.degree(50)));
        Mockito.when((Object)store.nodeGetDegree(Matchers.anyLong(), (Direction)Matchers.eq((Object)Direction.OUTGOING), Matchers.anyInt())).then(HeuristicsTestSupport.answerWithDistribution(10, HeuristicsTestSupport.degree(1), 20, HeuristicsTestSupport.degree(4), 85, HeuristicsTestSupport.degree(5)));
        return store;
    }

    private static void mockNodeLiveness(double liveNodes, StoreReadLayer store) {
        int alive = (int)(liveNodes * 100.0);
        int dead = 100 - alive;
        if (alive < dead) {
            Mockito.when((Object)store.nodeExists(Matchers.anyLong())).then(HeuristicsTestSupport.answerWithDistribution(alive, HeuristicsTestSupport.value(true), dead, HeuristicsTestSupport.value(false)));
        } else {
            Mockito.when((Object)store.nodeExists(Matchers.anyLong())).then(HeuristicsTestSupport.answerWithDistribution(dead, HeuristicsTestSupport.value(false), alive, HeuristicsTestSupport.value(true)));
        }
    }

    private static Answer<?> answerWithDistribution(Object ... alternatingPercentileAndProvider) {
        final Random rand = new Random();
        final Map probabilities = MapUtil.map((Object[])alternatingPercentileAndProvider);
        final int[] percentiles = new int[probabilities.size()];
        Object[] raw = probabilities.keySet().toArray();
        for (int i = 0; i < raw.length; ++i) {
            percentiles[i] = (Integer)raw[i];
        }
        Arrays.sort(percentiles);
        return new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                float r = rand.nextInt(100);
                for (int i = 0; i < percentiles.length; ++i) {
                    if (!(r <= (float)percentiles[i])) continue;
                    return ((Provider)probabilities.get(percentiles[i])).instance();
                }
                return ((Provider)probabilities.get(percentiles[percentiles.length - 1])).instance();
            }
        };
    }

    private static Provider<PrimitiveIntIterator> ids(final int ... ids) {
        return new Provider<PrimitiveIntIterator>(){

            public PrimitiveIntIterator instance() {
                return PrimitiveIntCollections.iterator((int[])ids);
            }
        };
    }

    private static Provider<Integer> degree(int degree) {
        return HeuristicsTestSupport.value(degree);
    }

    private static <V> Provider<V> value(final V value) {
        return new Provider<V>(){

            public V instance() {
                return value;
            }
        };
    }
}

