/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.kernel.impl.api.statistics.NodeLivenessData;
import org.neo4j.kernel.impl.util.statistics.RollingAverage;

public class NodeLivenessDataTest {
    @Test
    public void shouldReportOneIfNoDataAreSampled() {
        NodeLivenessData tracker = new NodeLivenessData(new RollingAverage.Parameters());
        tracker.recalculate();
        MatcherAssert.assertThat((Object)tracker.liveEntitiesRatio(), (Matcher)CoreMatchers.equalTo((Object)1.0));
    }

    @Test
    public void shouldReportZeroLiveNodesIfItHasSeenNoLiveNodes() {
        NodeLivenessData tracker = new NodeLivenessData(new RollingAverage.Parameters());
        tracker.recordDeadEntity();
        tracker.recalculate();
        MatcherAssert.assertThat((Object)tracker.liveEntitiesRatio(), (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    public void shouldReportAPercentageOfLiveDeadNodeAccordinglyToTheObservedRecords() {
        NodeLivenessData tracker = new NodeLivenessData(new RollingAverage.Parameters());
        tracker.recordLiveEntity();
        tracker.recordDeadEntity();
        tracker.recordLiveEntity();
        tracker.recalculate();
        MatcherAssert.assertThat((Object)tracker.liveEntitiesRatio(), (Matcher)Matchers.closeTo((double)0.6666, (double)1.0E-4));
    }

    @Test
    public void shouldReportOneIfOnlyLiveNodesAreRecorded() {
        NodeLivenessData tracker = new NodeLivenessData(new RollingAverage.Parameters());
        tracker.recordLiveEntity();
        tracker.recalculate();
        MatcherAssert.assertThat((Object)tracker.liveEntitiesRatio(), (Matcher)CoreMatchers.equalTo((Object)1.0));
    }
}

