/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.api.statistics.HeuristicsTestSupport;
import org.neo4j.kernel.impl.api.statistics.SamplingStatisticsService;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollectedData;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollector;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.TargetDirectory;

public class SamplingStatisticsServiceTest {
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        StoreReadLayer store = HeuristicsTestSupport.generateStore();
        StatisticsCollectedData collectedData = new StatisticsCollectedData();
        SamplingStatisticsService service = new SamplingStatisticsService(collectedData, store, null);
        StatisticsCollector collector = new StatisticsCollector(store, collectedData);
        collector.run();
        service.save(this.fs, new File(this.dir.directory(), "somefile"));
        StatisticsCollectedData expected = (StatisticsCollectedData)SamplingStatisticsService.load((FileSystemAbstraction)this.fs, (File)new File(this.dir.directory(), "somefile"), (StoreReadLayer)store, null).statistics();
        MatcherAssert.assertThat((Object)expected, (Matcher)CoreMatchers.equalTo((Object)collector.collectedData()));
    }

    @Test
    public void shouldSerializeTwiceAndDeserialize() throws Exception {
        StoreReadLayer store = HeuristicsTestSupport.generateStore();
        StatisticsCollectedData collectedData = new StatisticsCollectedData();
        SamplingStatisticsService service = new SamplingStatisticsService(collectedData, store, null);
        StatisticsCollector collector = new StatisticsCollector(store, collectedData);
        collector.run();
        service.save(this.fs, new File(this.dir.directory(), "somefile"));
        service.save(this.fs, new File(this.dir.directory(), "somefile"));
        StatisticsCollectedData expected = (StatisticsCollectedData)SamplingStatisticsService.load((FileSystemAbstraction)this.fs, (File)new File(this.dir.directory(), "somefile"), (StoreReadLayer)store, null).statistics();
        MatcherAssert.assertThat((Object)expected, (Matcher)CoreMatchers.equalTo((Object)collector.collectedData()));
    }
}

