/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.statistics.HeuristicsTestSupport;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollectedData;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollector;
import org.neo4j.kernel.impl.util.statistics.RollingAverage;

public class StatisticsCollectorTest {
    @Test
    public void shouldGatherLabelDistribution() throws Throwable {
        double equalityTolerance = 0.2;
        StatisticsCollectedData data = new StatisticsCollectedData(new RollingAverage.Parameters(1024L, equalityTolerance));
        StatisticsCollector collector = new StatisticsCollector(HeuristicsTestSupport.generateStore(), data);
        collector.run();
        collector.run();
        MatcherAssert.assertThat((Object)collector.collectedData().labelDistribution(0), (Matcher)Matchers.closeTo((double)0.2, (double)equalityTolerance));
        MatcherAssert.assertThat((Object)collector.collectedData().labelDistribution(1), (Matcher)Matchers.closeTo((double)0.8, (double)equalityTolerance));
    }

    @Test
    public void shouldGatherRelationshipTypeAndDirectionDistribution() throws Exception {
        double equalityTolerance = 0.2;
        StatisticsCollectedData data = new StatisticsCollectedData(new RollingAverage.Parameters(1024L, equalityTolerance));
        StatisticsCollector collector = new StatisticsCollector(HeuristicsTestSupport.generateStore(), data);
        collector.run();
        collector.run();
        MatcherAssert.assertThat((Object)collector.collectedData().relationshipTypeDistribution(0), (Matcher)Matchers.closeTo((double)0.4, (double)equalityTolerance));
        MatcherAssert.assertThat((Object)collector.collectedData().relationshipTypeDistribution(1), (Matcher)Matchers.closeTo((double)0.5, (double)equalityTolerance));
    }

    @Test
    public void shouldGatherRelationshipDegreeByLabelDistribution() throws Exception {
        StatisticsCollectedData data = new StatisticsCollectedData();
        StatisticsCollector collector = new StatisticsCollector(HeuristicsTestSupport.generateStore(), data);
        collector.run();
        collector.run();
        MatcherAssert.assertThat((Object)collector.collectedData().degree(1, 0, Direction.INCOMING), (Matcher)Matchers.closeTo((double)44.0, (double)10.0));
        MatcherAssert.assertThat((Object)collector.collectedData().degree(1, 0, Direction.OUTGOING), (Matcher)Matchers.closeTo((double)4.4, (double)1.0));
    }

    @Test
    public void shouldGatherLiveNodes() throws Throwable {
        StatisticsCollectedData data = new StatisticsCollectedData();
        StatisticsCollector collector = new StatisticsCollector(HeuristicsTestSupport.generateStore(0.6), data);
        collector.run();
        collector.run();
        collector.run();
        collector.run();
        collector.run();
        collector.run();
        MatcherAssert.assertThat((Object)collector.collectedData().liveNodesRatio(), (Matcher)Matchers.closeTo((double)0.6, (double)0.1));
    }

    @Test
    public void shouldGatherMaxNodes() throws Throwable {
        StatisticsCollectedData data = new StatisticsCollectedData();
        StatisticsCollector collector = new StatisticsCollector(HeuristicsTestSupport.generateStore(), data);
        collector.run();
        collector.run();
        MatcherAssert.assertThat((Object)collector.collectedData().maxAddressableNodes(), (Matcher)CoreMatchers.equalTo((Object)1000L));
    }
}

