/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.NodeManager;

public class CacheLayerTest {
    private final DiskLayer diskLayer = (DiskLayer)Mockito.mock(DiskLayer.class);
    private final PersistenceCache persistenceCache = (PersistenceCache)Mockito.mock(PersistenceCache.class);
    private final SchemaCache schemaCache = (SchemaCache)Mockito.mock(SchemaCache.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
    private final CacheLayer context = new CacheLayer(this.diskLayer, this.persistenceCache, this.indexingService, this.schemaCache, this.nodeManager);

    @Test
    public void shouldGetCachedLabelsIfCached() throws EntityNotFoundException {
        long nodeId = 3L;
        int[] labels = new int[]{1, 2, 3};
        Mockito.when((Object)this.persistenceCache.nodeGetLabels(org.mockito.Matchers.eq((long)nodeId), (CacheLoader)org.mockito.Matchers.any(CacheLoader.class))).thenReturn((Object)labels);
        PrimitiveIntIterator receivedLabels = this.context.nodeGetLabels(nodeId);
        Assert.assertArrayEquals((int[])labels, (int[])PrimitiveIntCollections.asArray((PrimitiveIntIterator)receivedLabels));
    }

    @Test
    public void shouldLoadAllConstraintsFromCache() throws Exception {
        Set constraints = IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(0, 1)});
        Mockito.when((Object)this.schemaCache.constraints()).thenReturn(constraints.iterator());
        MatcherAssert.assertThat((Object)IteratorUtil.asSet((Iterator)this.context.constraintsGetAll()), (Matcher)Matchers.equalTo((Object)constraints));
    }

    @Test
    public void shouldLoadConstraintsByLabelFromCache() throws Exception {
        int labelId = 0;
        Set constraints = IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(labelId, 1)});
        Mockito.when((Object)this.schemaCache.constraintsForLabel(labelId)).thenReturn(constraints.iterator());
        MatcherAssert.assertThat((Object)IteratorUtil.asSet((Iterator)this.context.constraintsGetForLabel(labelId)), (Matcher)Matchers.equalTo((Object)constraints));
    }

    @Test
    public void shouldLoadConstraintsByLabelAndPropertyFromCache() throws Exception {
        int labelId = 0;
        int propertyId = 1;
        Set constraints = IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(labelId, propertyId)});
        Mockito.when((Object)this.schemaCache.constraintsForLabelAndProperty(labelId, propertyId)).thenReturn(constraints.iterator());
        MatcherAssert.assertThat((Object)IteratorUtil.asSet((Iterator)this.context.constraintsGetForLabelAndPropertyKey(labelId, propertyId)), (Matcher)Matchers.equalTo((Object)constraints));
    }

    @Test
    public void shouldLoadRelationshipsFromCache() throws Exception {
        long nodeId = 3L;
        int[] relTypes = new int[]{1, 2};
        PrimitiveLongIterator rels = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        Mockito.when((Object)this.persistenceCache.nodeGetRelationships(org.mockito.Matchers.eq((long)nodeId), (Direction)org.mockito.Matchers.eq((Object)Direction.BOTH), (int[])org.mockito.Matchers.eq((Object)relTypes))).thenReturn((Object)rels);
        PrimitiveLongIterator recievedRels = this.context.nodeListRelationships(nodeId, Direction.BOTH, relTypes);
        Assert.assertEquals((Object)rels, (Object)recievedRels);
    }
}

