/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.Providers;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DiskLayerTest {
    private GraphDatabaseAPI db;
    private final Label label1 = DynamicLabel.label((String)"first-label");
    private final Label label2 = DynamicLabel.label((String)"second-label");
    private final String propertyKey = "name";
    private KernelStatement state;
    private DiskLayer statement;

    @Test
    public void should_be_able_to_list_labels_for_node() throws Exception {
        int labelId2;
        int labelId1;
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            nodeId = this.db.createNode(new Label[]{this.label1, this.label2}).getId();
            String labelName1 = this.label1.name();
            String labelName2 = this.label2.name();
            labelId1 = this.statement.labelGetForName(labelName1);
            labelId2 = this.statement.labelGetOrCreateForName(labelName2);
            tx.success();
        }
        PrimitiveIntIterator readLabels = this.statement.nodeGetLabels(nodeId);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(labelId1, labelId2)), (Object)IteratorUtil.addToCollection((PrimitiveIntIterator)readLabels, new HashSet()));
    }

    @Test
    public void should_be_able_to_get_label_name_for_label() throws Exception {
        String labelName = this.label1.name();
        int labelId = this.statement.labelGetOrCreateForName(labelName);
        String readLabelName = this.statement.labelGetName(labelId);
        Assert.assertEquals((Object)labelName, (Object)readLabelName);
    }

    @Test
    public void labels_should_not_leak_out_as_properties() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "none").newGraphDatabase();
        Node node = DiskLayerTest.createLabeledNode(db, MapUtil.map((Object[])new Object[]{"name", "Node"}), this.label1);
        Assert.assertThat(Neo4jMatchers.getPropertyKeys(db, (PropertyContainer)node), Neo4jMatchers.containsOnly("name"));
    }

    @Test
    public void should_return_all_nodes_with_label() throws Exception {
        Node node1 = DiskLayerTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "First", "age", 1L}), this.label1);
        Node node2 = DiskLayerTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"type", "Node", "count", 10}), this.label1, this.label2);
        int labelId1 = this.statement.labelGetForName(this.label1.name());
        int labelId2 = this.statement.labelGetForName(this.label2.name());
        PrimitiveLongIterator nodesForLabel1 = this.statement.nodesGetForLabel(this.state, labelId1);
        PrimitiveLongIterator nodesForLabel2 = this.statement.nodesGetForLabel(this.state, labelId2);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{node1.getId(), node2.getId()}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)nodesForLabel1));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{node2.getId()}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)nodesForLabel2));
    }

    @Test
    public void should_get_all_node_properties() throws Exception {
        Object[] properties;
        String longString = "AlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalong";
        for (Object value : properties = new Object[]{longString, this.gimme(String.class), this.gimme(Long.TYPE), this.gimme(Integer.TYPE), this.gimme(Byte.TYPE), this.gimme(Short.TYPE), this.gimme(Boolean.TYPE), this.gimme(Character.TYPE), this.gimme(Float.TYPE), this.gimme(Double.TYPE), this.array(0, String.class), this.array(0, Long.TYPE), this.array(0, Integer.TYPE), this.array(0, Byte.TYPE), this.array(0, Short.TYPE), this.array(0, Boolean.TYPE), this.array(0, Character.TYPE), this.array(0, Float.TYPE), this.array(0, Double.TYPE), this.array(1, String.class), this.array(1, Long.TYPE), this.array(1, Integer.TYPE), this.array(1, Byte.TYPE), this.array(1, Short.TYPE), this.array(1, Boolean.TYPE), this.array(1, Character.TYPE), this.array(1, Float.TYPE), this.array(1, Double.TYPE), this.array(256, String.class), this.array(256, Long.TYPE), this.array(256, Integer.TYPE), this.array(256, Byte.TYPE), this.array(256, Short.TYPE), this.array(256, Boolean.TYPE), this.array(256, Character.TYPE), this.array(256, Float.TYPE), this.array(256, Double.TYPE)}) {
            long nodeId = DiskLayerTest.createLabeledNode((GraphDatabaseService)this.db, Collections.singletonMap("prop", value), this.label1).getId();
            Property property = (Property)IteratorUtil.single((Iterator)this.statement.nodeGetAllProperties(nodeId));
            Assert.assertTrue((String)(property + ".valueEquals(" + value + ")"), (boolean)property.valueEquals(value));
        }
    }

    @Test
    public void should_create_property_key_if_not_exists() throws Exception {
        long id = this.statement.propertyKeyGetOrCreateForName("name");
        Assert.assertTrue((String)"Should have created a non-negative id", (id >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void should_get_previously_created_property_key() throws Exception {
        long id = this.statement.propertyKeyGetOrCreateForName("name");
        long secondId = this.statement.propertyKeyGetForName("name");
        Assert.assertEquals((long)id, (long)secondId);
    }

    @Test
    public void should_be_able_to_get_or_create_previously_created_property_key() throws Exception {
        long id = this.statement.propertyKeyGetOrCreateForName("name");
        long secondId = this.statement.propertyKeyGetOrCreateForName("name");
        Assert.assertEquals((long)id, (long)secondId);
    }

    @Test
    public void should_fail_if_get_non_existent_property_key() throws Exception {
        int propertyKey = this.statement.propertyKeyGetForName("non-existent-property-key");
        Assert.assertEquals((long)-1L, (long)propertyKey);
    }

    @Test
    public void should_find_nodes_with_given_label_and_property_via_index() throws Exception {
        IndexDescriptor index = this.createIndexAndAwaitOnline(this.label1, "name");
        String name = "Mr. Taylor";
        Node mrTaylor = DiskLayerTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", name}), this.label1);
        try (Transaction ignored = this.db.beginTx();){
            Set foundNodes = IteratorUtil.asUniqueSet((PrimitiveLongIterator)this.statement.nodesGetFromIndexLookup(this.state, 1L, (Object)name));
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{mrTaylor.getId()}), (Object)foundNodes);
        }
    }

    @Before
    public void before() {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        DependencyResolver resolver = this.db.getDependencyResolver();
        IndexingService indexingService = (IndexingService)resolver.resolveDependency(IndexingService.class);
        NeoStore neoStore = ((XaDataSourceManager)resolver.resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getNeoStore();
        this.statement = new DiskLayer((PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class), (LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (RelationshipTypeTokenHolder)resolver.resolveDependency(RelationshipTypeTokenHolder.class), new SchemaStorage((RecordStore)neoStore.getSchemaStore()), Providers.singletonProvider((Object)neoStore), indexingService);
        this.state = new KernelStatement(null, (IndexReaderFactory)new IndexReaderFactory.Caching(indexingService), (LabelScanStore)resolver.resolveDependency(LabelScanStore.class), null, null, null, null);
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    private static Node createLabeledNode(GraphDatabaseService db, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private IndexDescriptor createIndexAndAwaitOnline(Label label, String propertyKey) throws Exception {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = this.db.schema().indexFor(label).on(propertyKey).create();
            tx.success();
        }
        var5_4 = null;
        try (Transaction ignored = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 10L, TimeUnit.SECONDS);
            IndexDescriptor indexDescriptor = this.statement.indexesGetForLabelAndPropertyKey(this.statement.labelGetForName(label.name()), this.statement.propertyKeyGetForName(propertyKey));
            return indexDescriptor;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    private Object array(int length, Class<?> componentType) {
        Object array = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.gimme(componentType));
        }
        return array;
    }

    private Object gimme(Class<?> type) {
        if (type == Integer.TYPE) {
            return 666;
        }
        if (type == Long.TYPE) {
            return 17L;
        }
        if (type == Double.TYPE) {
            return Math.PI * 2;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(3.14f);
        }
        if (type == Short.TYPE) {
            return (short)8733;
        }
        if (type == Byte.TYPE) {
            return (byte)123;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('Z');
        }
        if (type == String.class) {
            return "hello world";
        }
        throw new IllegalArgumentException(type.getName());
    }
}

