/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Thunk;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;

public class PersistenceCacheTest {
    private PersistenceCache persistenceCache;
    private AutoLoadingCache<NodeImpl> nodeCache;
    private final long nodeId = 1L;
    private final KernelStatement state = (KernelStatement)Mockito.mock(KernelStatement.class);

    @Test
    public void shouldLoadAndCacheNodeLabels() throws Exception {
        int[] labels = new int[]{1, 2, 3};
        CacheLoader loader = (CacheLoader)Mockito.mock(CacheLoader.class);
        Mockito.when((Object)loader.load(1L)).thenReturn((Object)labels);
        NodeImpl node = new NodeImpl(1L);
        Mockito.when((Object)this.nodeCache.get(1L)).thenReturn((Object)node);
        boolean hasLabel1 = this.persistenceCache.nodeHasLabel(1L, 1, loader);
        boolean hasLabel2 = this.persistenceCache.nodeHasLabel(1L, 2, loader);
        Assert.assertTrue((boolean)hasLabel1);
        Assert.assertTrue((boolean)hasLabel2);
        ((CacheLoader)Mockito.verify((Object)loader, (VerificationMode)Mockito.times((int)1))).load(1L);
        ((AutoLoadingCache)Mockito.verify(this.nodeCache, (VerificationMode)Mockito.times((int)2))).get(1L);
    }

    @Test
    public void shouldEvictNode() throws Exception {
        this.persistenceCache.evictNode(1L);
        ((AutoLoadingCache)Mockito.verify(this.nodeCache, (VerificationMode)Mockito.times((int)1))).remove(1L);
    }

    @Test
    public void shouldApplyUpdates() throws Exception {
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)this.nodeCache.getIfCached(1L)).thenReturn((Object)node);
        this.persistenceCache.apply(Arrays.asList(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[]{2L}, (long[])new long[]{1L})));
        ((NodeImpl)Mockito.verify((Object)node)).commitLabels(new int[]{1});
    }

    @Before
    public void init() {
        this.nodeCache = (AutoLoadingCache)Mockito.mock(AutoLoadingCache.class);
        AutoLoadingCache relCache = (AutoLoadingCache)Mockito.mock(AutoLoadingCache.class);
        this.persistenceCache = new PersistenceCache(this.nodeCache, relCache, (Thunk)Mockito.mock(Thunk.class), (NodeManager)Mockito.mock(NodeManager.class));
    }
}

