/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.CustomCacheProvider;
import org.neo4j.kernel.impl.cache.StrongReferenceCache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.test.Barrier;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.ThreadingRule;
import org.neo4j.tooling.GlobalGraphOperations;

public class CacheRaceTest {
    private final NodeCache nodeCache = new NodeCache();
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseFactory factory) {
            factory.setCacheProviders(Arrays.asList(this.cacheProvider()));
        }

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.cache_type, "strong");
        }

        private CacheProvider cacheProvider() {
            return new CustomCacheProvider("strong", new Callable<Cache<NodeImpl>>(){

                @Override
                public Cache<NodeImpl> call() throws Exception {
                    return CacheRaceTest.this.nodeCache;
                }
            }, new Callable<Cache<RelationshipImpl>>(){

                @Override
                public Cache<RelationshipImpl> call() throws Exception {
                    return new StrongReferenceCache("RelationshipCache");
                }
            });
        }
    };
    @Rule
    public final ThreadingRule threading = new ThreadingRule();

    @Test
    public void shouldNotGetDuplicateRelationshipsForNewNode() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        Barrier.Control committing = new Barrier.Control();
        Future<Node> node = this.threading.execute(this.createNode(committing), graphDb);
        committing.await();
        this.nodeCache.clear();
        Barrier.Control updateCache = this.nodeCache.blockThread("create-node");
        this.threading.threadBlockMonitor(Thread.currentThread(), new Release(updateCache));
        committing.release();
        updateCache.await();
        List<String> before = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        updateCache.release();
        node.get();
        List<String> after = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        Assert.assertEquals((String)CacheRaceTest.join("\n\t", after), (long)before.size(), (long)after.size());
    }

    @Test
    public void shouldNotGetDuplicateRelationshipsForUpdatedNode() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        Node node = (Node)this.createNode(Barrier.NONE).apply((Object)graphDb);
        Barrier.Control committing = new Barrier.Control();
        Future<Relationship> rel = this.threading.execute(this.addRelationship(committing), node);
        committing.await();
        this.nodeCache.clear();
        Barrier.Control updateCache = this.nodeCache.blockThread("add-relationship");
        this.threading.threadBlockMonitor(Thread.currentThread(), new Release(updateCache));
        committing.release();
        updateCache.await();
        List<String> before = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        updateCache.release();
        rel.get();
        List<String> after = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        Assert.assertEquals((String)CacheRaceTest.join("\n\t", after), (long)before.size(), (long)after.size());
    }

    private Function<GraphDatabaseService, Node> createNode(final Barrier done) {
        return new NamedFunction<GraphDatabaseService, Node>("create-node"){

            public Node apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node = graphDb.createNode();
                    node.createRelationshipTo(graphDb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                    tx.success();
                    done.reached();
                    Node node2 = node;
                    return node2;
                }
            }
        };
    }

    private Function<Node, Relationship> addRelationship(final Barrier done) {
        return new NamedFunction<Node, Relationship>("add-relationship"){

            public Relationship apply(Node node) {
                GraphDatabaseService graphDb = node.getGraphDatabase();
                try (Transaction tx = graphDb.beginTx();){
                    Relationship rel = node.createRelationshipTo(graphDb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                    tx.success();
                    done.reached();
                    Relationship relationship = rel;
                    return relationship;
                }
            }
        };
    }

    private static List<String> countRelationshipsOfAllNodes(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ArrayList<String> relationships = new ArrayList<String>();
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodes()) {
                for (Relationship relationship : node.getRelationships()) {
                    relationships.add(String.format("(%d)%s[%d]%s(%d)", node.getId(), node.equals(relationship.getStartNode()) ? "-" : "<-", relationship.getId(), node.equals(relationship.getEndNode()) ? "-" : "->", relationship.getOtherNode(node).getId()));
                }
            }
            tx.success();
            ArrayList<String> arrayList = relationships;
            return arrayList;
        }
    }

    private static String join(String sep, Collection<?> items) {
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(sep).append(item);
        }
        return result.toString();
    }

    private static class NodeCache
    extends StrongReferenceCache<NodeImpl> {
        private final Map<String, Barrier> barriers = new ConcurrentHashMap<String, Barrier>();

        public NodeCache() {
            super("NodeCache");
        }

        public Barrier.Control blockThread(String threadName) {
            Barrier.Control barrier = new Barrier.Control();
            this.barriers.put(threadName, barrier);
            return barrier;
        }

        public NodeImpl get(long key) {
            Barrier barrier = this.barriers.get(Thread.currentThread().getName());
            if (barrier != null) {
                barrier.reached();
            }
            return (NodeImpl)super.get(key);
        }
    }

    private static class Release
    implements Runnable {
        private final Barrier.Control barrierControl;

        public Release(Barrier.Control barrierControl) {
            this.barrierControl = barrierControl;
        }

        @Override
        public void run() {
            this.barrierControl.release();
        }
    }
}

