/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CacheTypesIT
extends AbstractNeo4jTestCase {
    private GraphDatabaseAPI newDb(String cacheType) {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type.name(), cacheType).newGraphDatabase();
    }

    @Test
    public void testDefaultCache() {
        GraphDatabaseAPI db = this.newDb(null);
        Assert.assertEquals((Object)"soft", (Object)this.nodeManager(db).getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testWeakRefCache() {
        GraphDatabaseAPI db = this.newDb("weak");
        Assert.assertEquals((Object)"weak", (Object)this.nodeManager(db).getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testSoftRefCache() {
        GraphDatabaseAPI db = this.newDb("soft");
        Assert.assertEquals((Object)"soft", (Object)this.nodeManager(db).getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testNoCache() {
        GraphDatabaseAPI db = this.newDb("none");
        Assert.assertEquals((Object)"none", (Object)this.nodeManager(db).getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testStrongCache() {
        GraphDatabaseAPI db = this.newDb("strong");
        Assert.assertEquals((Object)"strong", (Object)this.nodeManager(db).getCacheType().getName());
        db.shutdown();
    }

    @Test
    public void testInvalidCache() {
        GraphDatabaseAPI db = null;
        try {
            db = this.newDb("whatever");
            Assert.fail((String)"Wrong cache type should not be allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NodeManager nodeManager(GraphDatabaseAPI db) {
        return (NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class);
    }
}

