/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.ReferenceCache;
import org.neo4j.kernel.impl.cache.ReferenceWithKey;
import org.neo4j.kernel.impl.cache.SoftValue;
import org.neo4j.kernel.impl.cache.TestCacheTypes;
import org.neo4j.kernel.impl.cache.WeakValue;

@RunWith(value=Parameterized.class)
public class ReferenceCacheTest {
    private SpyCreatingValueFactory spyFactory;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new SpyCreatingValueFactory(WeakValue.WEAK_VALUE_FACTORY)}, {new SpyCreatingValueFactory(SoftValue.SOFT_VALUE_FACTORY)});
    }

    public ReferenceCacheTest(SpyCreatingValueFactory factory) {
        this.spyFactory = factory;
        this.spyFactory.reset();
    }

    @Test
    public void shouldHandleExistingCacheEntryBeingGarbageCollectedDuringPutIfAbsent() throws Exception {
        ReferenceCache cache = new ReferenceCache("MyCache!", (ReferenceWithKey.Factory)this.spyFactory);
        TestCacheTypes.Entity originalEntity = new TestCacheTypes.Entity(0L);
        cache.put((EntityWithSizeObject)originalEntity);
        this.spyFactory.clearAndQueueReferenceNo(0);
        TestCacheTypes.Entity newEntity = new TestCacheTypes.Entity(0L);
        TestCacheTypes.Entity returnedEntity = (TestCacheTypes.Entity)cache.put((EntityWithSizeObject)newEntity);
        Assert.assertEquals((Object)newEntity, (Object)returnedEntity);
        Assert.assertEquals((Object)newEntity, (Object)cache.get(0L));
    }

    @Test
    public void shouldForceACacheCleanupAfterManyPutsWithoutReading() throws Exception {
        int i;
        ReferenceCache cache = new ReferenceCache("MyCache!", (ReferenceWithKey.Factory)this.spyFactory);
        for (i = 0; i < 5000; ++i) {
            cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(i));
        }
        for (i = 0; i < 2500; ++i) {
            this.spyFactory.clearAndQueueReferenceNo(i);
        }
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(5000L));
        Assert.assertEquals((long)2501L, (long)cache.size());
        for (i = 0; i < 2500; ++i) {
            Assert.assertNull((Object)cache.get((long)i));
        }
    }

    @Test
    public void shouldReturnTheValueIfNotGCed() throws Exception {
        ReferenceCache cache = new ReferenceCache("MyCache!", (ReferenceWithKey.Factory)this.spyFactory);
        TestCacheTypes.Entity entity = new TestCacheTypes.Entity(0L);
        cache.put((EntityWithSizeObject)entity);
        TestCacheTypes.Entity returnedEntity = (TestCacheTypes.Entity)cache.get(0L);
        Assert.assertEquals((Object)entity, (Object)returnedEntity);
    }

    @Test
    public void shouldHandleReferenceGarbageCollectedDuringGet() throws Exception {
        ReferenceCache cache = new ReferenceCache("MyCache!", (ReferenceWithKey.Factory)this.spyFactory);
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(0L));
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(1L));
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(2L));
        this.spyFactory.clearAndQueueReferenceNo(0);
        this.spyFactory.clearAndQueueReferenceNo(1);
        TestCacheTypes.Entity returnedEntity = (TestCacheTypes.Entity)cache.get(1L);
        Assert.assertNull((Object)returnedEntity);
        Assert.assertEquals((long)1L, (long)cache.size());
    }

    @Test
    public void shouldPollAfterAPutAllInvocation() {
        int i;
        int i2;
        ReferenceCache cache = new ReferenceCache("MyCache!", (ReferenceWithKey.Factory)this.spyFactory);
        for (i2 = 0; i2 < 2500; ++i2) {
            cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(i2));
        }
        for (i2 = 0; i2 < 1666; ++i2) {
            this.spyFactory.clearAndQueueReferenceNo(i2);
        }
        ArrayList<TestCacheTypes.Entity> entities = new ArrayList<TestCacheTypes.Entity>();
        for (i = 2500; i < 5001; ++i) {
            entities.add(new TestCacheTypes.Entity(i));
        }
        cache.putAll(entities);
        Assert.assertEquals((long)3335L, (long)cache.size());
        for (i = 0; i < 1666; ++i) {
            Assert.assertNull((Object)cache.get((long)i));
        }
    }

    @Test
    public void shouldHandleReferenceGarbageCollectedDuringRemove() throws Exception {
        ReferenceCache cache = new ReferenceCache("MyCache!", (ReferenceWithKey.Factory)this.spyFactory);
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(0L));
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(1L));
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(2L));
        cache.put((EntityWithSizeObject)new TestCacheTypes.Entity(3L));
        this.spyFactory.clearAndQueueReferenceNo(0);
        this.spyFactory.clearAndQueueReferenceNo(1);
        TestCacheTypes.Entity returnedEntity = (TestCacheTypes.Entity)cache.remove(1L);
        Assert.assertNull((Object)returnedEntity);
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertNull((Object)cache.get(0L));
        Assert.assertNull((Object)cache.get(1L));
        Assert.assertNotNull((Object)cache.get(2L));
        Assert.assertNotNull((Object)cache.get(3L));
    }

    static class SpyCreatingValueFactory
    implements ReferenceWithKey.Factory {
        ArrayList<ReferenceWithKey> values = new ArrayList();
        private final ArrayList<Object> hardReferencesToStopGC = new ArrayList();
        private final ReferenceWithKey.Factory refFactory;

        SpyCreatingValueFactory(ReferenceWithKey.Factory referenceFactory) {
            this.refFactory = referenceFactory;
        }

        public <FK, FV> ReferenceWithKey<FK, FV> newReference(FK key, FV value, ReferenceQueue<? super FV> queue) {
            ReferenceWithKey ref = (ReferenceWithKey)Mockito.spy((Object)this.refFactory.newReference(key, value, queue));
            this.hardReferencesToStopGC.add(value);
            this.values.add(ref);
            return ref;
        }

        public void clearAndQueueReferenceNo(int index) {
            ReferenceWithKey val = this.values.get(index);
            val.clear();
            val.enqueue();
        }

        public void reset() {
            this.values.clear();
            this.hardReferencesToStopGC.clear();
        }
    }
}

