/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.SoftLruCache;
import org.neo4j.kernel.impl.cache.StrongReferenceCache;
import org.neo4j.kernel.impl.cache.WeakLruCache;

public class TestCacheTypes {
    @Test
    public void softCacheShouldHonorPutSemantics() throws Exception {
        this.assertCacheHonorsPutsSemantics((Cache<EntityWithSizeObject>)new SoftLruCache("test"));
    }

    @Test
    public void weakCacheShouldHonorPutSemantics() throws Exception {
        this.assertCacheHonorsPutsSemantics((Cache<EntityWithSizeObject>)new WeakLruCache("test"));
    }

    @Test
    public void strongCacheShouldHonorPutSemantics() throws Exception {
        this.assertCacheHonorsPutsSemantics((Cache<EntityWithSizeObject>)new StrongReferenceCache("test"));
    }

    private void assertCacheHonorsPutsSemantics(Cache<EntityWithSizeObject> cache) {
        Entity version1 = new Entity(10L);
        Assert.assertTrue((version1 == cache.put((EntityWithSizeObject)version1) ? 1 : 0) != 0);
        Entity version2 = new Entity(10L);
        Assert.assertTrue((version1 == cache.put((EntityWithSizeObject)version2) ? 1 : 0) != 0);
    }

    public static class Entity
    implements EntityWithSizeObject {
        private int registeredSize;
        private final long id;

        Entity(long id) {
            this.id = id;
        }

        public int sizeOfObjectInBytesIncludingOverhead() {
            return 0;
        }

        public long getId() {
            return this.id;
        }

        public void setRegisteredSize(int size) {
            this.registeredSize = size;
        }

        public int getRegisteredSize() {
            return this.registeredSize;
        }
    }
}

