/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseFactory;

public class AutoconfTest {
    private ImpermanentGraphDatabase db;

    @Before
    public void given() {
        this.db = (ImpermanentGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @Test
    public void shouldConfigureDatabaseMemoryMappingAutomatically() throws Exception {
        Config config = this.db.getConfig();
        this.assertMemoryMappingAutoConfigured(config, "relationshipstore.db");
        this.assertMemoryMappingAutoConfigured(config, "nodestore.db");
        this.assertMemoryMappingAutoConfigured(config, "propertystore.db");
        this.assertMemoryMappingAutoConfigured(config, "propertystore.db.strings");
        this.assertMemoryMappingAutoConfigured(config, "propertystore.db.arrays");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void stopDb() {
        try {
            if (this.db != null) {
                this.db.shutdown();
            }
        }
        finally {
            this.db = null;
        }
    }

    private void assertMemoryMappingAutoConfigured(Config config, String store) {
        Long configuredValue = (Long)config.get(DefaultWindowPoolFactory.memoryMappingSetting((String)("neostore." + store)));
        Assert.assertTrue((String)String.format("Memory mapping for '%s' should be greater than 0, was %s", store, configuredValue), (configuredValue > 0L ? 1 : 0) != 0);
    }
}

