/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class JumpingFileSystemAbstraction
extends LifecycleAdapter
implements FileSystemAbstraction {
    private final int sizePerJump;
    private final EphemeralFileSystemAbstraction actualFileSystem = new EphemeralFileSystemAbstraction();

    public JumpingFileSystemAbstraction(int sizePerJump) {
        this.sizePerJump = sizePerJump;
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        StoreFileChannel channel = (StoreFileChannel)this.actualFileSystem.open(fileName, mode);
        if (fileName.getName().equals("neostore.nodestore.db") || fileName.getName().equals("neostore.nodestore.db.labels") || fileName.getName().equals("neostore.relationshipstore.db") || fileName.getName().equals("neostore.propertystore.db") || fileName.getName().equals("neostore.propertystore.db.strings") || fileName.getName().equals("neostore.propertystore.db.arrays") || fileName.getName().equals("neostore.relationshipgroupstore.db")) {
            return new JumpingFileChannel(channel, this.recordSizeFor(fileName));
        }
        return channel;
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, "rw"), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, "r"));
    }

    public Reader openAsReader(File fileName, String encoding) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), encoding);
    }

    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), encoding);
    }

    public StoreChannel create(File fileName) throws IOException {
        return this.open(fileName, "rw");
    }

    public boolean fileExists(File fileName) {
        return this.actualFileSystem.fileExists(fileName);
    }

    public long getFileSize(File fileName) {
        return this.actualFileSystem.getFileSize(fileName);
    }

    public boolean deleteFile(File fileName) {
        return this.actualFileSystem.deleteFile(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.actualFileSystem.deleteRecursively(directory);
    }

    public boolean mkdir(File fileName) {
        return this.actualFileSystem.mkdir(fileName);
    }

    public void mkdirs(File fileName) {
        this.actualFileSystem.mkdirs(fileName);
    }

    public boolean renameFile(File from, File to) throws IOException {
        return this.actualFileSystem.renameFile(from, to);
    }

    public FileLock tryLock(File fileName, StoreChannel channel) throws IOException {
        return this.actualFileSystem.tryLock(fileName, channel);
    }

    public File[] listFiles(File directory) {
        return this.actualFileSystem.listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.actualFileSystem.listFiles(directory, filter);
    }

    public boolean isDirectory(File file) {
        return this.actualFileSystem.isDirectory(file);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.actualFileSystem.moveToDirectory(file, toDirectory);
    }

    public void copyFile(File from, File to) throws IOException {
        this.actualFileSystem.copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.actualFileSystem.copyRecursively(fromDirectory, toDirectory);
    }

    private int recordSizeFor(File fileName) {
        if (fileName.getName().endsWith("nodestore.db")) {
            return 15;
        }
        if (fileName.getName().endsWith("relationshipstore.db")) {
            return 34;
        }
        if (fileName.getName().endsWith("propertystore.db.strings") || fileName.getName().endsWith("propertystore.db.arrays")) {
            return AbstractDynamicStore.getRecordSize((int)120);
        }
        if (fileName.getName().endsWith("propertystore.db")) {
            return 41;
        }
        if (fileName.getName().endsWith("nodestore.db.labels")) {
            return Integer.parseInt(GraphDatabaseSettings.label_block_size.getDefaultValue()) + 8;
        }
        if (fileName.getName().endsWith("schemastore.db")) {
            return AbstractDynamicStore.getRecordSize((int)56);
        }
        if (fileName.getName().endsWith("relationshipgroupstore.db")) {
            return AbstractDynamicStore.getRecordSize((int)25);
        }
        throw new IllegalArgumentException(fileName.getPath());
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return this.actualFileSystem.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public void shutdown() {
        this.actualFileSystem.shutdown();
    }

    public class JumpingFileChannel
    extends StoreFileChannel {
        private final int recordSize;

        public JumpingFileChannel(StoreFileChannel actual, int recordSize) {
            super(actual);
            this.recordSize = recordSize;
        }

        private long translateIncoming(long position) {
            return this.translateIncoming(position, false);
        }

        private long translateIncoming(long position, boolean allowFix) {
            long actualRecord = position / (long)this.recordSize;
            if (actualRecord < (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                return position;
            }
            long jumpIndex = (actualRecord + (long)JumpingFileSystemAbstraction.this.sizePerJump) / 0x100000000L;
            long diff = actualRecord - jumpIndex * 0x100000000L;
            diff = this.assertWithinDiff(diff, allowFix);
            long offsettedRecord = jumpIndex * (long)JumpingFileSystemAbstraction.this.sizePerJump + diff;
            return offsettedRecord * (long)this.recordSize;
        }

        private long translateOutgoing(long offsettedPosition) {
            long offsettedRecord = offsettedPosition / (long)this.recordSize;
            if (offsettedRecord < (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                return offsettedPosition;
            }
            long jumpIndex = (offsettedRecord - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) / (long)JumpingFileSystemAbstraction.this.sizePerJump + 1L;
            long diff = (offsettedRecord - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) % (long)JumpingFileSystemAbstraction.this.sizePerJump - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2);
            this.assertWithinDiff(diff, false);
            long actualRecord = jumpIndex * 0x100000000L - (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2) + diff;
            return actualRecord * (long)this.recordSize;
        }

        private long assertWithinDiff(long diff, boolean allowFix) {
            if (diff < (long)(-JumpingFileSystemAbstraction.this.sizePerJump / 2) || diff > (long)(JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                if (allowFix) {
                    if (diff < (long)(-JumpingFileSystemAbstraction.this.sizePerJump / 2)) {
                        return -JumpingFileSystemAbstraction.this.sizePerJump / 2;
                    }
                    return JumpingFileSystemAbstraction.this.sizePerJump / 2;
                }
                throw new IllegalArgumentException("" + diff);
            }
            return diff;
        }

        public long position() throws IOException {
            return this.translateOutgoing(super.position());
        }

        public JumpingFileChannel position(long newPosition) throws IOException {
            super.position(this.translateIncoming(newPosition));
            return this;
        }

        public long size() throws IOException {
            return this.translateOutgoing(super.size());
        }

        public JumpingFileChannel truncate(long size) throws IOException {
            super.truncate(this.translateIncoming(size, true));
            return this;
        }

        public int read(ByteBuffer dst, long position) throws IOException {
            return super.read(dst, this.translateIncoming(position));
        }

        public int write(ByteBuffer src, long position) throws IOException {
            return super.write(src, this.translateIncoming(position));
        }
    }
}

