/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.NoDuplicatesPropertyChainVerifier;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyChainVerifier;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.ConsoleLogger;

public class NoDuplicatesPropertyChainVerifierTest {
    private StringBuffer buffer;
    private StringLogger logger;
    private Primitive entity = new NodeImpl(42L);
    private PropertyChainVerifier chainVerifier;

    @Before
    public void setUp() {
        this.buffer = new StringBuffer();
        this.logger = StringLogger.wrap((StringBuffer)this.buffer);
        this.chainVerifier = new NoDuplicatesPropertyChainVerifier();
        this.chainVerifier.addObserver((PropertyChainVerifier.Observer)new NodeManager.CappedLoggingDuplicatePropertyObserver(new ConsoleLogger(StringLogger.cappedLogger((StringLogger)this.logger, (CappedOperation.Switch)CappedOperation.time((long)2L, (TimeUnit)TimeUnit.HOURS)))));
    }

    @Test
    public void shouldLogNothingWhenChainHasNoDuplicates() throws Exception {
        DefinedProperty[] propertyChain = new DefinedProperty[]{Property.charProperty((int)1, (char)'a'), Property.charProperty((int)2, (char)'b')};
        this.chainVerifier.verifySortedPropertyChain(propertyChain, this.entity);
        Assert.assertThat((Object)this.buffer.length(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldLogNothingWhenTheChainIsEmpty() {
        this.chainVerifier.verifySortedPropertyChain(new DefinedProperty[0], this.entity);
        Assert.assertThat((Object)this.buffer.length(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldLogWhenMoreThanOnePropertyHasTheSameKeyId() {
        DefinedProperty[] propertyChain = new DefinedProperty[]{Property.charProperty((int)13, (char)'x'), Property.charProperty((int)13, (char)'y')};
        this.chainVerifier.verifySortedPropertyChain(propertyChain, this.entity);
        String output = this.buffer.toString();
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"WARNING: Duplicate property records have been detected in this database store. For further details and resolution please refer to http://neo4j.com/technote/cr73nh"));
    }
}

