/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;

public class NodeProxySingleRelationshipTest {
    private static final long REL_ID = 1L;
    private static final RelationshipType loves = DynamicRelationshipType.withName((String)"LOVES");

    @Test
    public void shouldQuietlyIgnoreSingleDuplicateEntryWhenGetSingleRelationshipCalled() throws Exception {
        NodeProxy nodeImpl = this.mockNodeWithRels(1L, 1L);
        Relationship singleRelationship = nodeImpl.getSingleRelationship(loves, Direction.OUTGOING);
        junit.framework.Assert.assertNotNull((Object)singleRelationship);
    }

    @Test
    public void shouldThrowExceptionIfMultipleDifferentEntries() throws Exception {
        NodeProxy node = this.mockNodeWithRels(1L, 2L);
        try {
            node.getSingleRelationship(loves, Direction.OUTGOING);
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfMultipleDifferentEntriesWithTwoOfThemBeingIdentical() throws Exception {
        NodeProxy node = this.mockNodeWithRels(1L, 1L, 2L, 2L);
        try {
            node.getSingleRelationship(loves, Direction.OUTGOING);
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private NodeProxy mockNodeWithRels(long ... relIds) throws EntityNotFoundException {
        ThreadToStatementContextBridge stmCtxBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        NodeProxy.NodeLookup nodeLookup = (NodeProxy.NodeLookup)Mockito.mock(NodeProxy.NodeLookup.class);
        GraphDatabaseService gds = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Mockito.when((Object)gds.getRelationshipById(1L)).thenReturn(Mockito.mock(Relationship.class));
        Mockito.when((Object)gds.getRelationshipById(2L)).thenReturn(Mockito.mock(Relationship.class));
        Mockito.when((Object)nodeLookup.getGraphDatabase()).thenReturn((Object)gds);
        NodeProxy nodeImpl = new NodeProxy(1L, nodeLookup, (RelationshipProxy.RelationshipLookups)Mockito.mock(RelationshipProxy.RelationshipLookups.class), stmCtxBridge);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        ReadOperations readOps = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)stmt.readOperations()).thenReturn((Object)readOps);
        Mockito.when((Object)stmCtxBridge.instance()).thenReturn((Object)stmt);
        Mockito.when((Object)readOps.relationshipTypeGetForName(loves.name())).thenReturn((Object)2);
        Mockito.when((Object)readOps.nodeGetRelationships(1L, Direction.OUTGOING, new int[]{2})).thenReturn((Object)PrimitiveLongCollections.iterator((long[])relIds));
        return nodeImpl;
    }
}

