/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class NodeProxyTest {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();
    private final String PROPERTY_KEY = "PROPERTY_KEY";
    private GraphDatabaseService db;

    @Before
    public void init() {
        this.db = this.dbRule.getGraphDatabaseService();
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() throws Exception {
        this.createNodeWith("PROPERTY_KEY");
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
            Assert.fail((String)"Expected exception to have been thrown");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() throws Exception {
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty(key, (Object)1);
            tx.success();
        }
    }
}

