/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyChainVerifier;
import org.neo4j.kernel.impl.core.RelationshipImpl;

@RunWith(value=Theories.class)
public class PrimitivePropertyLoadingTest {
    private static final long entityId = 42L;
    @DataPoint
    public static Primitive nodeImpl = new NodeImpl(42L);
    @DataPoint
    public static Primitive relationshipImpl = new RelationshipImpl(42L, 2L, 3L, 4, false);

    @Test
    public void shouldSortTheGraphPropertyChainPriorToVerifyingIt() throws Exception {
        GraphPropertiesImpl graphProperties = new GraphPropertiesImpl(null, null);
        this.shouldSortThePropertyChainPriorToVerifyingIt((Primitive)graphProperties);
    }

    @Theory
    @Test
    public void shouldSortThePropertyChainPriorToVerifyingIt(Primitive dataPoint) throws Exception {
        DefinedProperty property2 = Property.booleanProperty((int)2, (boolean)true);
        DefinedProperty property1 = Property.booleanProperty((int)1, (boolean)false);
        DefinedProperty property3 = Property.booleanProperty((int)3, (boolean)true);
        List<DefinedProperty> values = Arrays.asList(property2, property1, property3);
        CacheLoader loader = (CacheLoader)Mockito.mock(CacheLoader.class);
        Mockito.when((Object)loader.load(42L)).thenReturn(values.iterator());
        Mockito.when((Object)loader.load(-1L)).thenReturn(values.iterator());
        CacheUpdateListener updateListener = CacheUpdateListener.NO_UPDATES;
        PropertyChainVerifier chainVerifier = (PropertyChainVerifier)Mockito.mock(PropertyChainVerifier.class);
        ArgumentCaptor verifiedProperties = ArgumentCaptor.forClass(DefinedProperty[].class);
        ArgumentCaptor verifiedEntity = ArgumentCaptor.forClass(Primitive.class);
        dataPoint.getProperties(loader, updateListener, chainVerifier);
        ((PropertyChainVerifier)Mockito.verify((Object)chainVerifier)).verifySortedPropertyChain((DefinedProperty[])verifiedProperties.capture(), (Primitive)verifiedEntity.capture());
        Object[] verifiedPropertiesValue = (DefinedProperty[])verifiedProperties.getValue();
        Assert.assertTrue((boolean)Arrays.equals(verifiedPropertiesValue, new DefinedProperty[]{property1, property2, property3}));
    }
}

