/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipIterator;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class RelationshipIteratorIssuesTest {
    @Test
    public void arrayIndexOutOfBoundsInRelTypeArrayWhenCreatingRelationshipsConcurrently() throws Exception {
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)nodeManager.newRelationshipProxyById(Matchers.anyLong())).thenAnswer(this.relationshipProxyWithId());
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)node.getMoreRelationships((NodeManager)Matchers.eq((Object)nodeManager), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class))).thenReturn((Object)NodeImpl.LoadStatus.NOTHING);
        ControlledRelIdIterator typeIterator = new ControlledRelIdIterator(0L);
        RelationshipIterator iterator = new RelationshipIterator(new RelIdIterator[]{typeIterator}, node, RelIdArray.DirectionWrapper.OUTGOING, new int[0], nodeManager, false, false);
        iterator.next();
        typeIterator.queueHasNextAnswers(false, false, true);
        long otherRelationship = 1L;
        long thirdRelationship = 2L;
        typeIterator.add(otherRelationship, thirdRelationship);
        iterator.next();
        long returnedThirdRelationship = iterator.next();
        Assert.assertEquals((long)thirdRelationship, (long)returnedThirdRelationship);
    }

    private Answer<RelationshipProxy> relationshipProxyWithId() {
        return new Answer<RelationshipProxy>(){

            public RelationshipProxy answer(InvocationOnMock invocation) throws Throwable {
                RelationshipProxy relationship = (RelationshipProxy)Mockito.mock(RelationshipProxy.class);
                Mockito.when((Object)relationship.getId()).thenReturn((Object)((Long)invocation.getArguments()[0]));
                return relationship;
            }
        };
    }

    private static class ControlledRelIdIterator
    implements RelIdIterator {
        private final List<Long> ids;
        private int index;
        private final Queue<Boolean> controlledHasNextResults = new LinkedList<Boolean>();

        ControlledRelIdIterator(Long ... ids) {
            this.ids = new ArrayList<Long>(Arrays.asList(ids));
        }

        void add(long ... ids) {
            for (long id : ids) {
                this.ids.add(id);
            }
        }

        void queueHasNextAnswers(boolean ... answers) {
            for (boolean answer : answers) {
                this.controlledHasNextResults.add(answer);
            }
        }

        public int getType() {
            return 0;
        }

        public boolean hasNext() {
            Boolean controlledAnswer = this.controlledHasNextResults.poll();
            if (controlledAnswer != null) {
                return controlledAnswer;
            }
            return this.index < this.ids.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.ids.get(this.index++);
        }

        public RelIdIterator updateSource(RelIdArray newSource, RelIdArray.DirectionWrapper direction) {
            throw new UnsupportedOperationException();
        }

        public void doAnotherRound() {
            throw new UnsupportedOperationException();
        }
    }
}

