/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.TestXa;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestChangingOfLogFormat {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private TestGraphDatabaseFactory factory;

    @Test
    public void inabilityToStartFromOldFormatFromNonCleanShutdown() throws Exception {
        File storeDir = new File("target/var/oldlog");
        GraphDatabaseService db = this.factory.newImpermanentDatabase(storeDir.getPath());
        File logBaseFileName = ((XaDataSourceManager)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().getXaContainer().getLogicalLog().getBaseFileName();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        Pair<Pair<File, File>, Pair<File, File>> copy = TestXa.copyLogicalLog(this.fs.get(), logBaseFileName);
        this.decrementLogFormat((File)((Pair)copy.other()).other());
        db.shutdown();
        TestXa.renameCopiedLogicalLog(this.fs.get(), copy);
        try {
            db = this.factory.newImpermanentDatabase(storeDir.getPath());
            Assert.fail((String)"Shouldn't be able to do recovery (and upgrade log format version) on non-clean shutdown");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void decrementLogFormat(File file) throws IOException {
        StoreChannel channel = this.fs.get().open(file, "rw");
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        channel.read(buffer);
        buffer.flip();
        long version = buffer.getLong();
        long logFormatVersion = version >>> 56;
        long oldVersion = (version &= 0xFFFFFFFFFFFFFFL) | logFormatVersion - 1L << 56;
        channel.position(0L);
        buffer.clear();
        buffer.putLong(oldVersion);
        buffer.flip();
        channel.write(buffer);
        channel.close();
    }

    @Before
    public void before() throws Exception {
        this.factory = new TestGraphDatabaseFactory().setFileSystem(this.fs.get());
    }

    @After
    public void after() throws Exception {
    }
}

