/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.test.ImpermanentDatabaseRule;

public class TestConcurrentModificationOfRelationshipChains {
    private static final RelationshipType TYPE = DynamicRelationshipType.withName((String)"POISON");
    private static final int RelationshipGrabSize = 2;
    private static final int DenseNode = 50;
    @Rule
    public ImpermanentDatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.relationship_grab_size, "2");
            builder.setConfig(GraphDatabaseSettings.dense_node_threshold, "50");
        }
    };
    private Node node1;
    private Node node2;
    private Relationship firstFromSecondBatch;

    @Before
    public void given() {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            this.node1 = graphDb.createNode();
            this.node2 = graphDb.createNode();
            this.firstFromSecondBatch = this.node1.createRelationshipTo(this.node2, TYPE);
            for (int i = 0; i < 2; ++i) {
                this.node1.createRelationshipTo(graphDb.createNode(), TYPE);
            }
            tx.success();
        }
        this.clearCaches();
        tx = graphDb.beginTx();
        var3_3 = null;
        try {
            Iterator relationships = this.node1.getRelationships().iterator();
            for (int i = 0; i < 2; ++i) {
                relationships.next();
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void relationshipChainPositionCachePoisoningFromSameThreadReReadNode() {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        TestConcurrentModificationOfRelationshipChains.deleteRelationshipInSameThread(this.firstFromSecondBatch);
        try (Transaction tx = graphDb.beginTx();){
            Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)this.node1.getRelationships()));
            tx.success();
        }
    }

    @Test
    public void relationshipChainPositionCachePoisoningFromDifferentThreadReReadNode() throws InterruptedException {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        TestConcurrentModificationOfRelationshipChains.deleteRelationshipInDifferentThread(this.firstFromSecondBatch);
        try (Transaction tx = graphDb.beginTx();){
            Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)this.node1.getRelationships()));
            tx.success();
        }
    }

    @Test
    public void relationshipChainPositionCachePoisoningFromSameThread() {
        Iterator rels;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            rels = this.node1.getRelationships().iterator();
            tx.success();
        }
        TestConcurrentModificationOfRelationshipChains.deleteRelationshipInSameThread(this.firstFromSecondBatch);
        tx = graphDb.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)2L, (long)IteratorUtil.count(rels));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void relationshipChainPositionCachePoisoningFromDifferentThreads() throws InterruptedException {
        Iterator rels;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            rels = this.node1.getRelationships().iterator();
            tx.success();
        }
        TestConcurrentModificationOfRelationshipChains.deleteRelationshipInDifferentThread(this.firstFromSecondBatch);
        tx = graphDb.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)2L, (long)IteratorUtil.count(rels));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotInvalidateNodeInCacheOnRollback() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            this.node2.getSingleRelationship(TYPE, Direction.INCOMING).delete();
            tx.failure();
        }
        tx = graphDb.beginTx();
        var3_3 = null;
        try {
            Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)this.node1.getRelationships()));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotInvalidateDenseNodeInCacheOnRollback() throws Exception {
        Node other;
        Node node;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            node = graphDb.createNode();
            for (int i = 0; i < 50; ++i) {
                node.createRelationshipTo(graphDb.createNode(), TYPE);
            }
            other = graphDb.createNode();
            other.createRelationshipTo(node, TYPE);
            tx.success();
        }
        this.clearCaches();
        tx = graphDb.beginTx();
        var5_3 = null;
        try {
            for (Relationship one : node.getRelationships(TYPE, Direction.OUTGOING)) {
                Assert.assertNotNull((Object)one);
            }
            tx.success();
        }
        catch (Throwable x2) {
            var5_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        var5_3 = null;
        try {
            other.getSingleRelationship(TYPE, Direction.OUTGOING).delete();
            tx.failure();
        }
        catch (Throwable x2) {
            var5_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        var5_3 = null;
        try {
            Assert.assertEquals((long)51L, (long)IteratorUtil.count((Iterable)node.getRelationships(new RelationshipType[]{TYPE})));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static void deleteRelationshipInSameThread(Relationship toDelete) {
        try (Transaction tx = toDelete.getGraphDatabase().beginTx();){
            toDelete.delete();
            tx.success();
        }
    }

    private static void deleteRelationshipInDifferentThread(final Relationship toDelete) throws InterruptedException {
        Runnable deleter = new Runnable(){

            @Override
            public void run() {
                TestConcurrentModificationOfRelationshipChains.deleteRelationshipInSameThread(toDelete);
            }
        };
        Thread t = new Thread(deleter);
        t.start();
        t.join();
    }

    private void clearCaches() {
        ((NodeManager)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
    }
}

