/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.util.MultipleCauseException;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestConcurrentRelationshipChainLoadingIssue {
    private final int relCount = 2;

    @Test
    public void tryToTriggerRelationshipLoadingStoppingMidWay() throws Throwable {
        this.tryToTriggerRelationshipLoadingStoppingMidWay(50);
    }

    @Test
    public void tryToTriggerRelationshipLoadingStoppingMidWayForDenseNodeRepresentation() throws Throwable {
        this.tryToTriggerRelationshipLoadingStoppingMidWay(1);
    }

    private void tryToTriggerRelationshipLoadingStoppingMidWay(int denseNodeThreshold) throws Throwable {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "weak").setConfig(GraphDatabaseSettings.relationship_grab_size, "1").setConfig(GraphDatabaseSettings.dense_node_threshold, "" + denseNodeThreshold).newGraphDatabase();
        Node node = this.createNodeWithRelationships(db);
        this.checkStateToHelpDiagnoseFlakeyTest(db, node);
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        int iterations = 0;
        while (System.currentTimeMillis() < end) {
            this.tryOnce(db, node, iterations++);
        }
    }

    private void checkStateToHelpDiagnoseFlakeyTest(GraphDatabaseAPI db, Node node) {
        this.loadNode(db, node);
        ((NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
        this.loadNode(db, node);
    }

    private void loadNode(GraphDatabaseAPI db, Node node) {
        try (Transaction ignored = db.beginTx();){
            IteratorUtil.count((Iterable)node.getRelationships());
        }
    }

    private void awaitStartSignalAndRandomTimeLonger(CountDownLatch startSignal) {
        try {
            startSignal.await();
            TestConcurrentRelationshipChainLoadingIssue.idleLoop((int)(System.currentTimeMillis() % 100000L));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryOnce(final GraphDatabaseAPI db, final Node node, int iterations) throws Throwable {
        ((NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
        ExecutorService executor = Executors.newCachedThreadPool();
        final CountDownLatch startSignal = new CountDownLatch(1);
        int threads = Runtime.getRuntime().availableProcessors();
        final List errors = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < threads; ++i) {
            executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TestConcurrentRelationshipChainLoadingIssue.this.awaitStartSignalAndRandomTimeLonger(startSignal);
                    Transaction transaction = db.beginTx();
                    try {
                        Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)node.getRelationships()));
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                    finally {
                        transaction.finish();
                    }
                }
            });
        }
        startSignal.countDown();
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        if (!errors.isEmpty()) {
            throw new MultipleCauseException(String.format("Exception(s) after %s iterations with %s threads", iterations, threads), errors);
        }
    }

    private static int idleLoop(int l) {
        AtomicInteger i = new AtomicInteger(0);
        for (int j = 0; j < l; ++j) {
            i.incrementAndGet();
        }
        return i.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNodeWithRelationships(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        try {
            int i;
            Node node = db.createNode();
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST2);
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }
}

