/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestCrashWithRebuildSlow {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crashAndRebuildSlowWithDynamicStringDeletions() throws Exception {
        String storeDir = "dir";
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(storeDir);
        this.produceNonCleanDefraggedStringStore((GraphDatabaseService)db);
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot(EphemeralFileSystemRule.shutdownDb((GraphDatabaseService)db));
        this.assertNumberOfFreeIdsEquals(storeDir, snapshot, 0);
        GraphDatabaseAPI newDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(snapshot).newImpermanentDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.rebuild_idgenerators_fast, "false").newGraphDatabase();
        this.assertNumberOfFreeIdsEquals(storeDir, snapshot, 4);
        Transaction transaction = newDb.beginTx();
        try {
            int nameCount = 0;
            int relCount = 0;
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)newDb).getAllNodes()) {
                ++nameCount;
                Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)newDb, Neo4jMatchers.hasProperty("name")));
                relCount += IteratorUtil.count((Iterable)node.getRelationships(Direction.OUTGOING));
            }
            Assert.assertEquals((long)16L, (long)nameCount);
            Assert.assertEquals((long)12L, (long)relCount);
        }
        finally {
            transaction.finish();
            newDb.shutdown();
        }
    }

    private void assertNumberOfFreeIdsEquals(String storeDir, EphemeralFileSystemAbstraction snapshot, int numberOfFreeIds) {
        Assert.assertEquals((long)(9 + 8 * numberOfFreeIds), (long)snapshot.getFileSize(new File(storeDir, "neostore.propertystore.db.strings.id")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceNonCleanDefraggedStringStore(GraphDatabaseService db) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Transaction tx = db.beginTx();
        try {
            Node previous = null;
            for (int i = 0; i < 20; ++i) {
                Node node = db.createNode();
                node.setProperty("name", (Object)"a looooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooong string");
                nodes.add(node);
                if (previous != null) {
                    previous.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
                }
                previous = node;
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = db.beginTx();
        try {
            TestCrashWithRebuildSlow.delete((Node)nodes.get(5));
            TestCrashWithRebuildSlow.delete((Node)nodes.get(7));
            TestCrashWithRebuildSlow.delete((Node)nodes.get(8));
            TestCrashWithRebuildSlow.delete((Node)nodes.get(10));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private static void delete(Node node) {
        for (Relationship rel : node.getRelationships()) {
            rel.delete();
        }
        node.delete();
    }
}

