/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.test.TargetDirectory;

public class TestDenseNodeRelChainPositionIT {
    @Test
    public void givenDenseNodeWhenAskForWrongDirectionThenIncorrectNrOfRelsReturned() throws Exception {
        Node node1;
        int denseNodeThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue()) + 1;
        File dbPath = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenDenseNodeWhenAskForWrongDirectionThenIncorrectNrOfRelsReturned");
        GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dbPath.getAbsolutePath()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            node1 = db.createNode();
            Node node2 = db.createNode();
            for (int i = 0; i < denseNodeThreshold; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
            }
            tx.success();
        }
        ((NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
        var6_5 = null;
        try (Transaction ignored = db.beginTx();){
            Node node1b = db.getNodeById(node1.getId());
            Iterable rels = node1b.getRelationships(Direction.INCOMING);
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)rels));
            Iterable rels2 = node1b.getRelationships(Direction.OUTGOING);
            Assert.assertEquals((long)denseNodeThreshold, (long)Iterables.count((Iterable)rels2));
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }
}

