/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestNeo4jCacheAndPersistence
extends AbstractNeo4jTestCase {
    private long node1Id = -1L;
    private long node2Id = -1L;
    private final String key1 = "key1";
    private final String key2 = "key2";
    private final String arrayKey = "arrayKey";
    private final Integer int1 = new Integer(1);
    private final Integer int2 = new Integer(2);
    private final String string1 = new String("1");
    private final String string2 = new String("2");
    private final int[] array = new int[]{1, 2, 3, 4, 5, 6, 7};

    @Before
    public void createTestingGraph() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        this.node1Id = node1.getId();
        this.node2Id = node2.getId();
        node1.setProperty("key1", (Object)this.int1);
        node1.setProperty("key2", (Object)this.string1);
        node2.setProperty("key1", (Object)this.int2);
        node2.setProperty("key2", (Object)this.string2);
        rel.setProperty("key1", (Object)this.int1);
        rel.setProperty("key2", (Object)this.string1);
        node1.setProperty("arrayKey", (Object)this.array);
        node2.setProperty("arrayKey", (Object)this.array);
        rel.setProperty("arrayKey", (Object)this.array);
        org.neo4j.graphdb.Transaction tx = this.getTransaction();
        tx.success();
        tx.finish();
        this.clearCache();
        tx = this.getGraphDb().beginTx();
        Assert.assertTrue((boolean)node1.getProperty("key1").equals(1));
        this.setTransaction(tx);
    }

    @After
    public void deleteTestingGraph() {
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Node node2 = this.getGraphDb().getNodeById(this.node2Id);
        node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH).delete();
        node1.delete();
        node2.delete();
    }

    @Test
    public void testAddProperty() {
        String key3 = "key3";
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Node node2 = this.getGraphDb().getNodeById(this.node2Id);
        Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
        node2.setProperty(key3, (Object)this.int1);
        rel.setProperty(key3, (Object)this.int2);
        Assert.assertTrue((boolean)node1.hasProperty("key1"));
        Assert.assertTrue((boolean)node2.hasProperty("key1"));
        Assert.assertTrue((boolean)node1.hasProperty("key2"));
        Assert.assertTrue((boolean)node2.hasProperty("key2"));
        Assert.assertTrue((boolean)node1.hasProperty("arrayKey"));
        Assert.assertTrue((boolean)node2.hasProperty("arrayKey"));
        Assert.assertTrue((boolean)rel.hasProperty("arrayKey"));
        Assert.assertTrue((!node1.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node2.hasProperty(key3));
        Assert.assertEquals((Object)this.int1, (Object)node1.getProperty("key1"));
        Assert.assertEquals((Object)this.int2, (Object)node2.getProperty("key1"));
        Assert.assertEquals((Object)this.string1, (Object)node1.getProperty("key2"));
        Assert.assertEquals((Object)this.string2, (Object)node2.getProperty("key2"));
        Assert.assertEquals((Object)this.int1, (Object)rel.getProperty("key1"));
        Assert.assertEquals((Object)this.string1, (Object)rel.getProperty("key2"));
        Assert.assertEquals((Object)this.int2, (Object)rel.getProperty(key3));
    }

    @Test
    public void testNodeRemoveProperty() {
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Node node2 = this.getGraphDb().getNodeById(this.node2Id);
        Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
        Assert.assertEquals((Object)1, (Object)node1.removeProperty("key1"));
        Assert.assertEquals((Object)2, (Object)node2.removeProperty("key1"));
        Assert.assertEquals((Object)1, (Object)rel.removeProperty("key1"));
        Assert.assertEquals((Object)this.string1, (Object)node1.removeProperty("key2"));
        Assert.assertEquals((Object)this.string2, (Object)node2.removeProperty("key2"));
        Assert.assertEquals((Object)this.string1, (Object)rel.removeProperty("key2"));
        Assert.assertTrue((node1.removeProperty("arrayKey") != null ? 1 : 0) != 0);
        Assert.assertTrue((node2.removeProperty("arrayKey") != null ? 1 : 0) != 0);
        Assert.assertTrue((rel.removeProperty("arrayKey") != null ? 1 : 0) != 0);
    }

    @Test
    public void testNodeChangeProperty() {
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Node node2 = this.getGraphDb().getNodeById(this.node2Id);
        Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
        node1.setProperty("key1", (Object)this.int2);
        node2.setProperty("key1", (Object)this.int1);
        rel.setProperty("key1", (Object)this.int2);
        int[] newIntArray = new int[]{3, 2, 1};
        node1.setProperty("arrayKey", (Object)newIntArray);
        node2.setProperty("arrayKey", (Object)newIntArray);
        rel.setProperty("arrayKey", (Object)newIntArray);
    }

    @Test
    public void testNodeGetProperties() {
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Assert.assertTrue((!node1.hasProperty(null) ? 1 : 0) != 0);
        Iterator keys = node1.getPropertyKeys().iterator();
        keys.next();
        keys.next();
        Assert.assertTrue((boolean)node1.hasProperty("key1"));
        Assert.assertTrue((boolean)node1.hasProperty("key2"));
    }

    private Relationship[] getRelationshipArray(Iterable<Relationship> relsIterable) {
        ArrayList<Relationship> relList = new ArrayList<Relationship>();
        for (Relationship rel : relsIterable) {
            relList.add(rel);
        }
        return relList.toArray(new Relationship[relList.size()]);
    }

    @Test
    public void testDirectedRelationship1() {
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.BOTH);
        Node[] nodes = rel.getNodes();
        Assert.assertEquals((long)2L, (long)nodes.length);
        Node node2 = this.getGraphDb().getNodeById(this.node2Id);
        Assert.assertTrue((nodes[0].equals(node1) && nodes[1].equals(node2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)node1, (Object)rel.getStartNode());
        Assert.assertEquals((Object)node2, (Object)rel.getEndNode());
        Relationship[] relArray = this.getRelationshipArray(node1.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        Assert.assertEquals((long)1L, (long)relArray.length);
        Assert.assertEquals((Object)rel, (Object)relArray[0]);
        relArray = this.getRelationshipArray(node2.getRelationships((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
        Assert.assertEquals((long)1L, (long)relArray.length);
        Assert.assertEquals((Object)rel, (Object)relArray[0]);
    }

    @Test
    public void testRelCountInSameTx() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Assert.assertEquals((long)1L, (long)this.getRelationshipArray(node1.getRelationships()).length);
        Assert.assertEquals((long)1L, (long)this.getRelationshipArray(node2.getRelationships()).length);
        rel.delete();
        Assert.assertEquals((long)0L, (long)this.getRelationshipArray(node1.getRelationships()).length);
        Assert.assertEquals((long)0L, (long)this.getRelationshipArray(node2.getRelationships()).length);
        node1.delete();
        node2.delete();
    }

    @Test
    public void testGetDirectedRelationship() {
        Node node1 = this.getGraphDb().getNodeById(this.node1Id);
        Relationship rel = node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING);
        Assert.assertEquals((Object)this.int1, (Object)rel.getProperty("key1"));
    }

    @Test
    public void testSameTxWithArray() {
        this.getTransaction().success();
        this.getTransaction().finish();
        this.newTransaction();
        Node nodeA = this.getGraphDb().createNode();
        Node nodeB = this.getGraphDb().createNode();
        Relationship relA = nodeA.createRelationshipTo(nodeB, (RelationshipType)MyRelTypes.TEST);
        nodeA.setProperty("arrayKey", (Object)this.array);
        relA.setProperty("arrayKey", (Object)this.array);
        this.clearCache();
        Assert.assertTrue((nodeA.getProperty("arrayKey") != null ? 1 : 0) != 0);
        Assert.assertTrue((relA.getProperty("arrayKey") != null ? 1 : 0) != 0);
        relA.delete();
        nodeA.delete();
        nodeB.delete();
    }

    @Test
    public void testAddCacheCleared() {
        Node nodeA = this.getGraphDb().createNode();
        nodeA.setProperty("1", (Object)1);
        Node nodeB = this.getGraphDb().createNode();
        Relationship rel = nodeA.createRelationshipTo(nodeB, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("1", (Object)1);
        this.getTransaction().success();
        this.getTransaction().finish();
        this.newTransaction();
        this.clearCache();
        nodeA.createRelationshipTo(nodeB, (RelationshipType)MyRelTypes.TEST);
        int count = 0;
        for (Relationship relToB : nodeA.getRelationships(new RelationshipType[]{MyRelTypes.TEST})) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        nodeA.setProperty("2", (Object)2);
        Assert.assertEquals((Object)1, (Object)nodeA.getProperty("1"));
        rel.setProperty("2", (Object)2);
        Assert.assertEquals((Object)1, (Object)rel.getProperty("1"));
        this.clearCache();
        this.getGraphDb().getNodeById(nodeA.getId());
        this.getGraphDb().getRelationshipById(rel.getId());
        this.getTransaction().success();
        this.getTransaction().finish();
        this.newTransaction();
        count = 0;
        for (Relationship relToB : nodeA.getRelationships(new RelationshipType[]{MyRelTypes.TEST})) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertEquals((Object)1, (Object)nodeA.getProperty("1"));
        Assert.assertEquals((Object)1, (Object)rel.getProperty("1"));
        Assert.assertEquals((Object)2, (Object)nodeA.getProperty("2"));
        Assert.assertEquals((Object)2, (Object)rel.getProperty("2"));
    }

    @Test
    public void testTxCacheLoadIsolation() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("someproptest", (Object)"testing");
        Node node1 = this.getGraphDb().createNode();
        node1.setProperty("someotherproptest", (Object)2);
        this.commit();
        TransactionManager txManager = (TransactionManager)this.getGraphDbAPI().getDependencyResolver().resolveDependency(TransactionManager.class);
        txManager.begin();
        node.setProperty("someotherproptest", (Object)"testing2");
        Relationship rel = node.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        Transaction txA = txManager.suspend();
        txManager.begin();
        Assert.assertEquals((Object)"testing", (Object)node.getProperty("someproptest"));
        Assert.assertTrue((!node.hasProperty("someotherproptest") ? 1 : 0) != 0);
        Assert.assertTrue((!node.hasRelationship() ? 1 : 0) != 0);
        this.clearCache();
        Assert.assertEquals((Object)"testing", (Object)node.getProperty("someproptest"));
        Assert.assertTrue((!node.hasProperty("someotherproptest") ? 1 : 0) != 0);
        Transaction txB = txManager.suspend();
        txManager.resume(txA);
        Assert.assertEquals((Object)"testing", (Object)node.getProperty("someproptest"));
        Assert.assertTrue((boolean)node.hasProperty("someotherproptest"));
        Assert.assertTrue((boolean)node.hasRelationship());
        this.clearCache();
        Assert.assertEquals((Object)"testing", (Object)node.getProperty("someproptest"));
        Assert.assertTrue((boolean)node.hasProperty("someotherproptest"));
        Assert.assertTrue((boolean)node.hasRelationship());
        txManager.suspend();
        txManager.resume(txB);
        Assert.assertEquals((Object)"testing", (Object)node.getProperty("someproptest"));
        Assert.assertTrue((!node.hasProperty("someotherproptest") ? 1 : 0) != 0);
        Assert.assertTrue((!node.hasRelationship() ? 1 : 0) != 0);
        txManager.rollback();
        txManager.resume(txA);
        node.delete();
        node1.delete();
        rel.delete();
        txManager.commit();
        this.newTransaction();
    }

    @Test
    public void testNodeMultiRemoveProperty() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("key0", (Object)"0");
        node.setProperty("key1", (Object)"1");
        node.setProperty("key2", (Object)"2");
        node.setProperty("key3", (Object)"3");
        node.setProperty("key4", (Object)"4");
        this.newTransaction();
        node.removeProperty("key3");
        node.removeProperty("key2");
        node.removeProperty("key3");
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)"0", (Object)node.getProperty("key0"));
        Assert.assertEquals((Object)"1", (Object)node.getProperty("key1"));
        Assert.assertEquals((Object)"4", (Object)node.getProperty("key4"));
        Assert.assertTrue((!node.hasProperty("key2") ? 1 : 0) != 0);
        Assert.assertTrue((!node.hasProperty("key3") ? 1 : 0) != 0);
        node.delete();
    }

    @Test
    public void testRelMultiRemoveProperty() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("key0", (Object)"0");
        rel.setProperty("key1", (Object)"1");
        rel.setProperty("key2", (Object)"2");
        rel.setProperty("key3", (Object)"3");
        rel.setProperty("key4", (Object)"4");
        this.newTransaction();
        rel.removeProperty("key3");
        rel.removeProperty("key2");
        rel.removeProperty("key3");
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)"0", (Object)rel.getProperty("key0"));
        Assert.assertEquals((Object)"1", (Object)rel.getProperty("key1"));
        Assert.assertEquals((Object)"4", (Object)rel.getProperty("key4"));
        Assert.assertTrue((!rel.hasProperty("key2") ? 1 : 0) != 0);
        Assert.assertTrue((!rel.hasProperty("key3") ? 1 : 0) != 0);
        rel.delete();
        node1.delete();
        node2.delete();
    }

    @Ignore(value="Can't depend on this behaviour since the introduction of dense nodes, at least the implementation of it currently")
    @Test
    public void testRelationshipCachingIterator() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship[] rels = new Relationship[100];
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = i < 50 ? node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST) : node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        }
        this.newTransaction();
        this.clearCache();
        List relIterable = Iterables.toList((Iterable)node1.getRelationships());
        HashSet<Relationship> relSet = new HashSet<Relationship>();
        for (Relationship rel : rels) {
            rel.delete();
            relSet.add(rel);
        }
        this.newTransaction();
        Assert.assertEquals(relSet, new HashSet(IteratorUtil.asCollection((Iterable)relIterable)));
        node1.delete();
        node2.delete();
    }

    @Test
    public void testLowGrabSize() {
        Node node2;
        Node node1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("relationship_grab_size", "1");
        String storePath = TestNeo4jCacheAndPersistence.getStorePath("neo2");
        TestNeo4jCacheAndPersistence.deleteFileOrDirectory(storePath);
        GraphDatabaseService graphDb = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(config).newGraphDatabase();
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            node1 = graphDb.createNode();
            node2 = graphDb.createNode();
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST2);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            tx.success();
        }
        tx = graphDb.beginTx();
        var7_5 = null;
        try {
            RelationshipType[] types = new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL};
            this.clearCache();
            Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)node1.getRelationships(types)));
            this.clearCache();
            Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)node1.getRelationships()));
            this.clearCache();
            Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)node2.getRelationships(types)));
            this.clearCache();
            Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)node2.getRelationships()));
            this.clearCache();
            Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)node1.getRelationships(Direction.OUTGOING)));
            this.clearCache();
            Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)node1.getRelationships(Direction.INCOMING)));
            this.clearCache();
            Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)node2.getRelationships(Direction.OUTGOING)));
            this.clearCache();
            Assert.assertEquals((long)2L, (long)IteratorUtil.count((Iterable)node2.getRelationships(Direction.INCOMING)));
            tx.success();
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        graphDb.shutdown();
    }

    @Test
    public void testAnotherLowGrabSize() {
        this.testLowGrabSize(false);
    }

    @Test
    public void testAnotherLowGrabSizeWithLoops() {
        this.testLowGrabSize(true);
    }

    private void testLowGrabSize(boolean includeLoops) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("relationship_grab_size", "2");
        String storePath = TestNeo4jCacheAndPersistence.getStorePath("neo2");
        TestNeo4jCacheAndPersistence.deleteFileOrDirectory(storePath);
        GraphDatabaseService graphDb = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(config).newGraphDatabase();
        org.neo4j.graphdb.Transaction tx = graphDb.beginTx();
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Node node3 = graphDb.createNode();
        HashSet<Relationship> outgoingOriginal = new HashSet<Relationship>();
        HashSet<Relationship> incomingOriginal = new HashSet<Relationship>();
        HashSet<Relationship> loopsOriginal = new HashSet<Relationship>();
        int total = 0;
        int totalOneDirection = 0;
        for (int i = 0; i < 33; ++i) {
            if (includeLoops) {
                loopsOriginal.add(node2.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
                ++total;
                ++totalOneDirection;
            }
            if (i % 2 == 0) {
                incomingOriginal.add(node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
                outgoingOriginal.add(node2.createRelationshipTo(node3, (RelationshipType)MyRelTypes.TEST));
            } else {
                outgoingOriginal.add(node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST));
                incomingOriginal.add(node3.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
            }
            total += 2;
            ++totalOneDirection;
        }
        tx.success();
        tx.finish();
        tx = graphDb.beginTx();
        HashSet<Relationship> rels = new HashSet<Relationship>();
        this.clearCache();
        HashSet outgoing = new HashSet(outgoingOriginal);
        HashSet incoming = new HashSet(incomingOriginal);
        HashSet loops = new HashSet(loopsOriginal);
        for (Relationship rel : node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST})) {
            Assert.assertTrue((boolean)rels.add(rel));
            if (rel.getStartNode().equals(node2) && rel.getEndNode().equals(node2)) {
                Assert.assertTrue((boolean)loops.remove(rel));
                continue;
            }
            if (rel.getStartNode().equals(node2)) {
                Assert.assertTrue((boolean)outgoing.remove(rel));
                continue;
            }
            Assert.assertTrue((boolean)incoming.remove(rel));
        }
        Assert.assertEquals((long)total, (long)rels.size());
        Assert.assertEquals((long)0L, (long)loops.size());
        Assert.assertEquals((long)0L, (long)incoming.size());
        Assert.assertEquals((long)0L, (long)outgoing.size());
        rels.clear();
        this.clearCache();
        outgoing = new HashSet(outgoingOriginal);
        incoming = new HashSet(incomingOriginal);
        loops = new HashSet(loopsOriginal);
        for (Relationship rel : node2.getRelationships(Direction.OUTGOING)) {
            Assert.assertTrue((boolean)rels.add(rel));
            if (rel.getStartNode().equals(node2) && rel.getEndNode().equals(node2)) {
                Assert.assertTrue((boolean)loops.remove(rel));
                continue;
            }
            if (rel.getStartNode().equals(node2)) {
                Assert.assertTrue((boolean)outgoing.remove(rel));
                continue;
            }
            Assert.fail((String)("There should be no incomming relationships " + rel));
        }
        Assert.assertEquals((long)totalOneDirection, (long)rels.size());
        Assert.assertEquals((long)0L, (long)loops.size());
        Assert.assertEquals((long)0L, (long)outgoing.size());
        rels.clear();
        this.clearCache();
        outgoing = new HashSet(outgoingOriginal);
        incoming = new HashSet(incomingOriginal);
        loops = new HashSet(loopsOriginal);
        for (Relationship rel : node2.getRelationships(Direction.INCOMING)) {
            Assert.assertTrue((boolean)rels.add(rel));
            if (rel.getStartNode().equals(node2) && rel.getEndNode().equals(node2)) {
                Assert.assertTrue((boolean)loops.remove(rel));
                continue;
            }
            if (rel.getEndNode().equals(node2)) {
                Assert.assertTrue((boolean)incoming.remove(rel));
                continue;
            }
            Assert.fail((String)("There should be no outgoing relationships " + rel));
        }
        Assert.assertEquals((long)totalOneDirection, (long)rels.size());
        Assert.assertEquals((long)0L, (long)loops.size());
        Assert.assertEquals((long)0L, (long)incoming.size());
        rels.clear();
        tx.success();
        tx.finish();
        graphDb.shutdown();
    }
}

