/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.util.RelIdArray;

public class TestOperationsOnDeletedRelationships {
    @Test
    public void shouldThrowNotFoundOnGetAllRelationshipsWhenRelationshipConcurrentlyDeleted() throws Exception {
        NodeImpl nodeImpl = new NodeImpl(1337L, false);
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)nodeManager.getRelationshipChainPosition((NodeImpl)Matchers.any(NodeImpl.class))).thenReturn((Object)new SingleChainPosition(1L));
        Mockito.when((Object)nodeManager.getMoreRelationships((NodeImpl)Matchers.any(NodeImpl.class), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class))).thenThrow(new Throwable[]{new InvalidRecordException("LURING!")});
        try {
            nodeImpl.getAllRelationships(nodeManager, RelIdArray.DirectionWrapper.BOTH);
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNotFoundWhenIteratingOverDeletedRelationship() throws Exception {
        NodeImpl fromNode = new NodeImpl(1337L, false);
        NodeManager nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)nodeManager.getMoreRelationships((NodeImpl)Matchers.any(NodeImpl.class), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class))).thenThrow(new Throwable[]{new InvalidRecordException("LURING!")});
        fromNode.setRelChainPosition((RelationshipLoadingPosition)new SingleChainPosition(1L));
        try {
            fromNode.getMoreRelationships(nodeManager, RelIdArray.DirectionWrapper.BOTH, new int[0]);
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

