/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;
import org.neo4j.qa.tooling.DumpProcessInformation;
import org.neo4j.qa.tooling.DumpVmInformation;
import org.neo4j.test.EmbeddedDatabaseRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcess;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction", method="doPrepare", on=BreakPoint.Event.EXIT)})
@RunWith(value=SubProcessTestRunner.class)
public class TestRelationshipConcurrentDeleteAndLoadCachePoisoning {
    private static final int RelationshipGrabSize = 2;
    @Rule
    public EmbeddedDatabaseRule database = new EmbeddedDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.relationship_grab_size, "2");
        }
    };
    public static final TargetDirectory targetDir = TargetDirectory.forTest(TestRelationshipConcurrentDeleteAndLoadCachePoisoning.class);
    private static DebuggedThread committer;
    private static DebuggedThread reader;

    @Test
    @EnabledBreakpoints(value={"doPrepare", "waitForPrepare", "readDone"})
    public void theTest() throws Exception {
        final GraphDatabaseAPI db = this.database.getGraphDatabaseAPI();
        Transaction tx = db.beginTx();
        final Node first = db.createNode();
        final Relationship theOneAfterTheGap = first.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"AC"));
        for (int i = 0; i < 2; ++i) {
            first.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"AC"));
        }
        tx.success();
        tx.finish();
        ((NodeManager)db.getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                Transaction tx = db.beginTx();
                theOneAfterTheGap.delete();
                tx.success();
                tx.finish();
            }
        };
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                TestRelationshipConcurrentDeleteAndLoadCachePoisoning.this.waitForPrepare();
                Transaction transaction = db.beginTx();
                first.getRelationships().iterator().next();
                transaction.finish();
                TestRelationshipConcurrentDeleteAndLoadCachePoisoning.this.readDone();
            }
        };
        Thread writerThread = new Thread(writer);
        Thread readerThread = new Thread(reader);
        readerThread.start();
        writerThread.start();
        this.dumpAndFailIfNotDeadWithin(readerThread, 1, TimeUnit.MINUTES);
        this.dumpAndFailIfNotDeadWithin(writerThread, 1, TimeUnit.MINUTES);
        Transaction transaction = db.beginTx();
        int count = IteratorUtil.count((Iterable)first.getRelationships());
        Assert.assertEquals((String)"Should have read relationships created minus one", (long)2L, (long)count);
        transaction.finish();
    }

    private void dumpAndFailIfNotDeadWithin(Thread thread, int duration, TimeUnit unit) throws Exception {
        thread.join(TimeUnit.MILLISECONDS.convert(duration, unit));
        if (thread.isAlive()) {
            File dumpDirectory = targetDir.cleanDirectory("dump");
            DumpVmInformation.dumpVmInfo(dumpDirectory);
            new DumpProcessInformation((Logging)new SystemOutLogging(), dumpDirectory).doThreadDump((Predicate<String>)Predicates.stringContains((String)SubProcess.class.getSimpleName()));
            Assert.fail((String)("Test didn't complete within a reasonable time, dumping process information to " + dumpDirectory));
        }
    }

    @BreakpointHandler(value={"doPrepare"})
    public static void onDoPrepare(BreakPoint self, DebugInterface di) {
        if (self.invocationCount() < 3) {
            return;
        }
        self.disable();
        committer = di.thread();
        committer.suspend(DebuggerDeadlockCallback.RESUME_THREAD);
        reader.resume();
    }

    @BreakpointTrigger(value="waitForPrepare")
    public void waitForPrepare() {
    }

    @BreakpointHandler(value={"waitForPrepare"})
    public static void onWaitForPrepare(BreakPoint self, DebugInterface di) {
        self.disable();
        reader = di.thread();
        reader.suspend(DebuggerDeadlockCallback.RESUME_THREAD);
    }

    @BreakpointTrigger(value="readDone")
    public void readDone() {
    }

    @BreakpointHandler(value={"readDone"})
    public static void onReadDone(BreakPoint self, DebugInterface di) {
        self.disable();
        committer.resume();
    }
}

