/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.lang.reflect.Field;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.TestShortString;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.GraphTransactionRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class TestShortStringProperties
extends TestShortString {
    @ClassRule
    public static DatabaseRule graphdb = new ImpermanentDatabaseRule();
    @Rule
    public GraphTransactionRule tx = new GraphTransactionRule(graphdb);
    private static final String LONG_STRING = "this is a really long string, believe me!";
    private static Field storeField;

    public void commit() {
        this.tx.success();
        graphdb.clearCache();
    }

    public void newTx() {
        this.tx.success();
        this.tx.begin();
    }

    @Test
    public void canAddMultipleShortStringsToTheSameNode() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        Node node = graphdb.getGraphDatabaseService().createNode();
        node.setProperty("key", (Object)"value");
        node.setProperty("reverse", (Object)"esrever");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(graphdb.getGraphDatabaseService(), Neo4jMatchers.hasProperty("key").withValue("value")));
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(graphdb.getGraphDatabaseService(), Neo4jMatchers.hasProperty("reverse").withValue("esrever")));
    }

    @Test
    public void canAddShortStringToRelationship() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        GraphDatabaseService db = graphdb.getGraphDatabaseService();
        Relationship rel = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"REL_TYPE"));
        rel.setProperty("type", (Object)"dimsedut");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertThat((Object)rel, Neo4jMatchers.inTx(db, Neo4jMatchers.hasProperty("type").withValue("dimsedut")));
    }

    @Test
    public void canUpdateShortStringInplace() throws Exception {
        try {
            long recordCount = this.dynamicRecordsInUse();
            long propCount = this.propertyRecordsInUse();
            Node node = graphdb.getGraphDatabaseService().createNode();
            node.setProperty("key", (Object)"value");
            this.newTx();
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
            Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
            Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
            node.setProperty("key", (Object)"other");
            this.commit();
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
            Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
            Assert.assertThat((Object)node, Neo4jMatchers.inTx(graphdb.getGraphDatabaseService(), Neo4jMatchers.hasProperty("key").withValue("other")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void canReplaceLongStringWithShortString() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.getGraphDatabaseService().createNode();
        node.setProperty("key", (Object)LONG_STRING);
        this.newTx();
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)LONG_STRING, (Object)node.getProperty("key"));
        node.setProperty("key", (Object)"value");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(graphdb.getGraphDatabaseService(), Neo4jMatchers.hasProperty("key").withValue("value")));
    }

    @Test
    public void canReplaceShortStringWithLongString() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.getGraphDatabaseService().createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.setProperty("key", (Object)LONG_STRING);
        this.commit();
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(graphdb.getGraphDatabaseService(), Neo4jMatchers.hasProperty("key").withValue(LONG_STRING)));
    }

    @Test
    public void canRemoveShortStringProperty() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        GraphDatabaseService db = graphdb.getGraphDatabaseService();
        Node node = db.createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.removeProperty("key");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)propCount, (long)this.propertyRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("key"))));
    }

    @Override
    protected void assertCanEncode(String string) {
        this.encode(string, true);
    }

    private void encode(String string, boolean isShort) {
        long recordCount = this.dynamicRecordsInUse();
        Node node = graphdb.getGraphDatabaseService().createNode();
        node.setProperty("key", (Object)string);
        this.newTx();
        if (isShort) {
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        } else {
            Assert.assertTrue((recordCount < this.dynamicRecordsInUse() ? 1 : 0) != 0);
        }
        graphdb.clearCache();
        Assert.assertEquals((Object)string, (Object)node.getProperty("key"));
    }

    private long propertyRecordsInUse() {
        return this.propertyStore().getNumberOfIdsInUse();
    }

    private long dynamicRecordsInUse() {
        try {
            return ((AbstractDynamicStore)storeField.get(this.propertyStore())).getNumberOfIdsInUse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PropertyStore propertyStore() {
        XaDataSourceManager dsMgr = (XaDataSourceManager)graphdb.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(XaDataSourceManager.class);
        return dsMgr.getNeoStoreDataSource().getXaConnection().getPropertyStore();
    }

    static {
        try {
            storeField = PropertyStore.class.getDeclaredField("stringPropertyStore");
            storeField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

