/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.api.state.TxStateImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TxStateTransactionDataSnapshot;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class TxStateTransactionDataViewTest {
    private final ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
    private final Statement stmt = (Statement)Mockito.mock(Statement.class);
    private final ReadOperations ops = (ReadOperations)Mockito.mock(ReadOperations.class);
    private final OldTxStateBridge oldTxState = (OldTxStateBridge)Mockito.mock(OldTxStateBridge.class);
    private final TxState state = new TxStateImpl(this.oldTxState, (PersistenceManager)Mockito.mock(PersistenceManager.class), (TxState.IdGeneration)Mockito.mock(TxState.IdGeneration.class));

    @Before
    public void setup() {
        Mockito.when((Object)this.bridge.instance()).thenReturn((Object)this.stmt);
        Mockito.when((Object)this.stmt.readOperations()).thenReturn((Object)this.ops);
        Mockito.when((Object)this.oldTxState.nodeCreate()).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        Mockito.when((Object)this.oldTxState.relationshipCreate(Matchers.anyInt(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
    }

    @Test
    public void showsCreatedNodes() throws Exception {
        this.state.nodeDoCreate();
        this.state.nodeDoCreate();
        Assert.assertThat(this.idList(this.snapshot().createdNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void showsDeletedNodes() throws Exception {
        this.state.nodeDoDelete(1L);
        this.state.nodeDoDelete(2L);
        Mockito.when((Object)this.ops.nodeGetAllCommittedProperties(1L)).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.ops.nodeGetAllCommittedProperties(2L)).thenReturn(Arrays.asList(Property.stringProperty((int)1, (String)"p")).iterator());
        Mockito.when((Object)this.ops.nodeGetCommittedLabels(1L)).thenReturn((Object)PrimitiveIntCollections.emptyIterator());
        Mockito.when((Object)this.ops.nodeGetCommittedLabels(2L)).thenReturn((Object)PrimitiveIntCollections.iterator((int[])new int[]{15}));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"key");
        Mockito.when((Object)this.ops.labelGetName(15)).thenReturn((Object)"label");
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assert.assertThat(this.idList(snapshot.deletedNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat((Object)((LabelEntry)Iterables.single((Iterable)snapshot.removedLabels())).label().name(), (Matcher)CoreMatchers.equalTo((Object)"label"));
        Assert.assertThat((Object)((PropertyEntry)Iterables.single((Iterable)snapshot.removedNodeProperties())).key(), (Matcher)CoreMatchers.equalTo((Object)"key"));
    }

    @Test
    public void showsAddedRelationships() throws Exception {
        this.state.relationshipDoCreate(1, 1L, 2L);
        this.state.relationshipDoCreate(1, 1L, 1L);
        Assert.assertThat(this.idList(this.snapshot().createdRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void showsRemovedRelationships() throws Exception {
        this.state.relationshipDoDelete(1L, 1L, 2L, 1);
        this.state.relationshipDoDelete(2L, 1L, 1L, 1);
        Mockito.when((Object)this.ops.relationshipGetAllCommittedProperties(1L)).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.ops.relationshipGetAllCommittedProperties(2L)).thenReturn(Arrays.asList(Property.stringProperty((int)1, (String)"p")).iterator());
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"key");
        TxStateTransactionDataSnapshot snapshot = this.snapshot();
        Assert.assertThat(this.idList(snapshot.deletedRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat((Object)((PropertyEntry)Iterables.single((Iterable)snapshot.removedRelationshipProperties())).key(), (Matcher)CoreMatchers.equalTo((Object)"key"));
    }

    @Test
    public void correctlySaysNodeIsDeleted() throws Exception {
        this.state.nodeDoDelete(1L);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)1L);
        Mockito.when((Object)this.ops.nodeGetAllCommittedProperties(1L)).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.ops.nodeGetCommittedLabels(1L)).thenReturn((Object)PrimitiveIntCollections.emptyIterator());
        Assert.assertThat((Object)this.snapshot().isDeleted(node), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void correctlySaysRelIsDeleted() throws Exception {
        this.state.relationshipDoDelete(1L, 1L, 2L, 1);
        Relationship rel = (Relationship)Mockito.mock(Relationship.class);
        Mockito.when((Object)rel.getId()).thenReturn((Object)1L);
        Mockito.when((Object)this.ops.relationshipGetAllCommittedProperties(1L)).thenReturn(Collections.emptyIterator());
        Assert.assertThat((Object)this.snapshot().isDeleted(rel), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldListAddedNodePropertiesProperties() throws Exception {
        DefinedProperty prevProp = Property.stringProperty((int)1, (String)"prevValue");
        this.state.nodeDoReplaceProperty(1L, (Property)prevProp, Property.stringProperty((int)1, (String)"newValue"));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.ops.nodeGetCommittedProperty(1L, 1)).thenReturn((Object)prevProp);
        Iterable propertyEntries = this.snapshot().assignedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.value(), (Matcher)CoreMatchers.equalTo((Object)"newValue"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Node)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedNodeProperties() throws Exception {
        DefinedProperty prevProp = Property.stringProperty((int)1, (String)"prevValue");
        this.state.nodeDoRemoveProperty(1L, prevProp);
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.ops.nodeGetCommittedProperty(1L, 1)).thenReturn((Object)prevProp);
        Iterable propertyEntries = this.snapshot().removedNodeProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Node)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedRelationshipProperties() throws Exception {
        DefinedProperty prevValue = Property.stringProperty((int)1, (String)"prevValue");
        this.state.relationshipDoRemoveProperty(1L, prevValue);
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.ops.relationshipGetCommittedProperty(1L, 1)).thenReturn((Object)prevValue);
        Iterable propertyEntries = this.snapshot().removedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Relationship)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListAddedRelationshipProperties() throws Exception {
        DefinedProperty prevProp = Property.stringProperty((int)1, (String)"prevValue");
        this.state.relationshipDoReplaceProperty(1L, (Property)prevProp, Property.stringProperty((int)1, (String)"newValue"));
        Mockito.when((Object)this.ops.propertyKeyGetName(1)).thenReturn((Object)"theKey");
        Mockito.when((Object)this.ops.relationshipGetCommittedProperty(1L, 1)).thenReturn((Object)prevProp);
        Iterable propertyEntries = this.snapshot().assignedRelationshipProperties();
        PropertyEntry entry = (PropertyEntry)Iterables.single((Iterable)propertyEntries);
        Assert.assertThat((Object)entry.key(), (Matcher)CoreMatchers.equalTo((Object)"theKey"));
        Assert.assertThat((Object)entry.value(), (Matcher)CoreMatchers.equalTo((Object)"newValue"));
        Assert.assertThat((Object)entry.previouslyCommitedValue(), (Matcher)CoreMatchers.equalTo((Object)"prevValue"));
        Assert.assertThat((Object)((Relationship)entry.entity()).getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(2, 1L);
        Mockito.when((Object)this.ops.labelGetName(2)).thenReturn((Object)"theLabel");
        Mockito.when((Object)this.ops.nodeGetCommittedLabels(1L)).thenReturn((Object)PrimitiveIntCollections.emptyIterator());
        Iterable labelEntries = this.snapshot().assignedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assert.assertThat((Object)entry.label().name(), (Matcher)CoreMatchers.equalTo((Object)"theLabel"));
        Assert.assertThat((Object)entry.node().getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldListRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(2, 1L);
        Mockito.when((Object)this.ops.labelGetName(2)).thenReturn((Object)"theLabel");
        Iterable labelEntries = this.snapshot().removedLabels();
        LabelEntry entry = (LabelEntry)Iterables.single((Iterable)labelEntries);
        Assert.assertThat((Object)entry.label().name(), (Matcher)CoreMatchers.equalTo((Object)"theLabel"));
        Assert.assertThat((Object)entry.node().getId(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    private List<Long> idList(Iterable<? extends PropertyContainer> entities) {
        ArrayList<Long> out = new ArrayList<Long>();
        for (PropertyContainer propertyContainer : entities) {
            out.add(propertyContainer instanceof Node ? ((Node)propertyContainer).getId() : ((Relationship)propertyContainer).getId());
        }
        return out;
    }

    private TxStateTransactionDataSnapshot snapshot() {
        return new TxStateTransactionDataSnapshot(this.state, (NodeProxy.NodeLookup)Mockito.mock(NodeProxy.NodeLookup.class), (RelationshipProxy.RelationshipLookups)Mockito.mock(RelationshipProxy.RelationshipLookups.class), this.bridge);
    }
}

