/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.impl.event.PropertyEntryImpl;

class ExpectedTransactionData {
    final Set<Node> expectedCreatedNodes = new HashSet<Node>();
    final Set<Relationship> expectedCreatedRelationships = new HashSet<Relationship>();
    final Set<Node> expectedDeletedNodes = new HashSet<Node>();
    final Set<Relationship> expectedDeletedRelationships = new HashSet<Relationship>();
    final Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedAssignedNodeProperties = new HashMap<Node, Map<String, PropertyEntryImpl<Node>>>();
    final Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedAssignedRelationshipProperties = new HashMap<Relationship, Map<String, PropertyEntryImpl<Relationship>>>();
    final Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedRemovedNodeProperties = new HashMap<Node, Map<String, PropertyEntryImpl<Node>>>();
    final Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedRemovedRelationshipProperties = new HashMap<Relationship, Map<String, PropertyEntryImpl<Relationship>>>();

    ExpectedTransactionData() {
    }

    void assignedProperty(Node node, String key, Object value, Object valueBeforeTx) {
        this.putInMap(this.expectedAssignedNodeProperties, node, key, value, valueBeforeTx);
    }

    void assignedProperty(Relationship rel, String key, Object value, Object valueBeforeTx) {
        this.putInMap(this.expectedAssignedRelationshipProperties, rel, key, value, valueBeforeTx);
    }

    void removedProperty(Node node, String key, Object value, Object valueBeforeTx) {
        this.putInMap(this.expectedRemovedNodeProperties, node, key, value, valueBeforeTx);
    }

    void removedProperty(Relationship rel, String key, Object value, Object valueBeforeTx) {
        this.putInMap(this.expectedRemovedRelationshipProperties, rel, key, value, valueBeforeTx);
    }

    <T extends PropertyContainer> void putInMap(Map<T, Map<String, PropertyEntryImpl<T>>> map, T entity, String key, Object value, Object valueBeforeTx) {
        Map<String, PropertyEntryImpl<T>> innerMap = map.get(entity);
        if (innerMap == null) {
            innerMap = new HashMap<String, PropertyEntryImpl<T>>();
            map.put(entity, innerMap);
        }
        innerMap.put(key, new PropertyEntryImpl<T>(entity, key, value, valueBeforeTx));
    }

    void compareTo(TransactionData data) {
        HashSet<Node> expectedCreatedNodes = new HashSet<Node>(this.expectedCreatedNodes);
        HashSet<Relationship> expectedCreatedRelationships = new HashSet<Relationship>(this.expectedCreatedRelationships);
        HashSet<Node> expectedDeletedNodes = new HashSet<Node>(this.expectedDeletedNodes);
        HashSet<Relationship> expectedDeletedRelationships = new HashSet<Relationship>(this.expectedDeletedRelationships);
        Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedAssignedNodeProperties = this.clone(this.expectedAssignedNodeProperties);
        Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedAssignedRelationshipProperties = this.clone(this.expectedAssignedRelationshipProperties);
        Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedRemovedNodeProperties = this.clone(this.expectedRemovedNodeProperties);
        Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedRemovedRelationshipProperties = this.clone(this.expectedRemovedRelationshipProperties);
        for (Node node : data.createdNodes()) {
            Assert.assertTrue((boolean)expectedCreatedNodes.remove(node));
            Assert.assertFalse((boolean)data.isDeleted(node));
        }
        Assert.assertTrue((String)("Expected some created nodes that weren't seen: " + expectedCreatedNodes), (boolean)expectedCreatedNodes.isEmpty());
        for (Relationship rel : data.createdRelationships()) {
            Assert.assertTrue((boolean)expectedCreatedRelationships.remove(rel));
            Assert.assertFalse((boolean)data.isDeleted(rel));
        }
        Assert.assertTrue((boolean)expectedCreatedRelationships.isEmpty());
        for (Node node : data.deletedNodes()) {
            Assert.assertTrue((String)("Unexpected deleted node " + node), (boolean)expectedDeletedNodes.remove(node));
            Assert.assertTrue((boolean)data.isDeleted(node));
        }
        Assert.assertTrue((boolean)expectedDeletedNodes.isEmpty());
        for (Relationship rel : data.deletedRelationships()) {
            Assert.assertTrue((boolean)expectedDeletedRelationships.remove(rel));
            Assert.assertTrue((boolean)data.isDeleted(rel));
        }
        Assert.assertTrue((boolean)expectedDeletedRelationships.isEmpty());
        for (PropertyEntry entry : data.assignedNodeProperties()) {
            this.checkAssigned(expectedAssignedNodeProperties, entry);
            Assert.assertFalse((boolean)data.isDeleted((Node)entry.entity()));
        }
        Assert.assertTrue((String)("Expected node properties not encountered " + expectedAssignedNodeProperties), (boolean)expectedAssignedNodeProperties.isEmpty());
        for (PropertyEntry entry : data.assignedRelationshipProperties()) {
            this.checkAssigned(expectedAssignedRelationshipProperties, entry);
            Assert.assertFalse((boolean)data.isDeleted((Relationship)entry.entity()));
        }
        Assert.assertTrue((boolean)expectedAssignedRelationshipProperties.isEmpty());
        for (PropertyEntry entry : data.removedNodeProperties()) {
            this.checkRemoved(expectedRemovedNodeProperties, entry);
        }
        Assert.assertTrue((boolean)expectedRemovedNodeProperties.isEmpty());
        for (PropertyEntry entry : data.removedRelationshipProperties()) {
            this.checkRemoved(expectedRemovedRelationshipProperties, entry);
        }
        Assert.assertTrue((boolean)expectedRemovedRelationshipProperties.isEmpty());
    }

    private <KEY extends PropertyContainer> Map<KEY, Map<String, PropertyEntryImpl<KEY>>> clone(Map<KEY, Map<String, PropertyEntryImpl<KEY>>> map) {
        HashMap<PropertyContainer, HashMap<String, PropertyEntryImpl<KEY>>> result = new HashMap<PropertyContainer, HashMap<String, PropertyEntryImpl<KEY>>>();
        for (PropertyContainer key : map.keySet()) {
            result.put(key, new HashMap<String, PropertyEntryImpl<KEY>>(map.get(key)));
        }
        return result;
    }

    <T extends PropertyContainer> void checkAssigned(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        this.fetchExpectedPropertyEntry(map, entry).compareToAssigned(entry);
    }

    <T extends PropertyContainer> void checkRemoved(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        this.fetchExpectedPropertyEntry(map, entry).compareToRemoved(entry);
    }

    <T extends PropertyContainer> PropertyEntryImpl<T> fetchExpectedPropertyEntry(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        Map<String, PropertyEntryImpl<T>> innerMap = map.get(entry.entity());
        Assert.assertNotNull((String)("Unexpected entity " + entry), innerMap);
        PropertyEntryImpl<T> expectedEntry = innerMap.remove(entry.key());
        Assert.assertNotNull((String)("Unexpacted property entry " + entry), expectedEntry);
        if (innerMap.isEmpty()) {
            map.remove(entry.entity());
        }
        return expectedEntry;
    }
}

