/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.event.IllBehavingXaDataSource;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.TransactionWriter;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.BufferingLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestKernelPanic {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void panicTest() throws Exception {
        BufferingLogger logger = new BufferingLogger();
        GraphDatabaseService graphDb = new TestGraphDatabaseFactory().setLogging((Logging)new SingleLoggingService((StringLogger)logger)).newImpermanentDatabase();
        XaDataSourceManager xaDs = (XaDataSourceManager)((GraphDatabaseAPI)graphDb).getDependencyResolver().resolveDependency(XaDataSourceManager.class);
        IllBehavingXaDataSource adversarialDataSource = new IllBehavingXaDataSource(UTF8.encode((String)"554342"), "adversarialDataSource");
        xaDs.registerDataSource((XaDataSource)adversarialDataSource);
        Panic panic = new Panic();
        graphDb.registerKernelEventHandler((KernelEventHandler)panic);
        org.neo4j.graphdb.Transaction gdbTx = graphDb.beginTx();
        TransactionManager txMgr = (TransactionManager)((GraphDatabaseAPI)graphDb).getDependencyResolver().resolveDependency(TransactionManager.class);
        Transaction tx = txMgr.getTransaction();
        graphDb.createNode();
        adversarialDataSource.getXaConnection().enlistResource(tx);
        try {
            gdbTx.success();
            gdbTx.finish();
            Assert.fail((String)"Should fail");
        }
        catch (Exception t) {
            while (!panic.panic) {
            }
        }
        finally {
            graphDb.unregisterKernelEventHandler((KernelEventHandler)panic);
        }
        try {
            Assert.assertTrue((boolean)panic.panic);
            Assert.assertThat((String)"Log didn't contain expected string", (Object)logger.toString(), (Matcher)Matchers.containsString((String)"at org.neo4j.kernel.impl.event.TestKernelPanic.panicTest"));
        }
        finally {
            graphDb.shutdown();
        }
    }

    @Test
    public void shouldPanicOnApplyTransactionFailure() throws Exception {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setTransactionInterceptorProviders(Arrays.asList(this.interceptorProviderThatBreaksStuff()));
        GraphDatabaseAPI db = (GraphDatabaseAPI)factory.newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.intercept_deserialized_transactions.name(), Boolean.TRUE.toString()).setConfig(TransactionInterceptorProvider.class.getSimpleName() + ".breaker", Boolean.TRUE.toString()).newGraphDatabase();
        XaDataSourceManager dsManager = (XaDataSourceManager)db.getDependencyResolver().resolveDependency(XaDataSourceManager.class);
        XaDataSource ds = dsManager.getXaDataSource("nioneodb");
        try {
            ds.applyCommittedTransaction(2L, this.simpleTransaction());
            Assert.fail((String)"Should have failed");
        }
        catch (BreakageException e) {
            // empty catch block
        }
        this.assertNotOk(this.beginTransaction((GraphDatabaseService)db));
        this.assertNotOk(this.applyTransaction(ds));
    }

    private void assertNotOk(Callable<Void> callable) {
        try {
            callable.call();
            Assert.fail((String)"Should have failed saying that tm not OK");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)this.someExceptionContainsMessage(e, "Kernel has encountered some problem"));
        }
    }

    private boolean someExceptionContainsMessage(Throwable e, String string) {
        while (e != null) {
            if (e.getMessage().contains(string)) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private Callable<Void> applyTransaction(final XaDataSource ds) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ds.applyCommittedTransaction(2L, TestKernelPanic.this.simpleTransaction());
                return null;
            }
        };
    }

    private Callable<Void> beginTransaction(final GraphDatabaseService db) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                db.beginTx();
                return null;
            }
        };
    }

    private ReadableByteChannel simpleTransaction() throws IOException {
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        TransactionWriter writer = new TransactionWriter((LogBuffer)buffer, 1, -1);
        writer.start(-1, -1, 0L);
        writer.add(new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue()), new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue()));
        writer.commit(false, 2L);
        writer.done();
        return buffer;
    }

    private TransactionInterceptorProvider interceptorProviderThatBreaksStuff() {
        return new TransactionInterceptorProvider("breaker"){

            public TransactionInterceptor create(TransactionInterceptor next, XaDataSource ds, String options, DependencyResolver dependencyResolver) {
                throw new AssertionError((Object)"I don't think this is needed");
            }

            public TransactionInterceptor create(XaDataSource ds, String options, DependencyResolver dependencyResolver) {
                return TestKernelPanic.this.interceptorThatBreaksStuff();
            }
        };
    }

    private TransactionInterceptor interceptorThatBreaksStuff() {
        return new TransactionInterceptor(){

            private void breakStuff() {
                throw new BreakageException();
            }

            public void visitRelationship(RelationshipRecord record) {
                this.breakStuff();
            }

            public void visitProperty(PropertyRecord record) {
                this.breakStuff();
            }

            public void visitRelationshipTypeToken(RelationshipTypeTokenRecord record) {
                this.breakStuff();
            }

            public void visitLabelToken(LabelTokenRecord record) {
                this.breakStuff();
            }

            public void visitPropertyKeyToken(PropertyKeyTokenRecord record) {
                this.breakStuff();
            }

            public void visitNode(NodeRecord record) {
                this.breakStuff();
            }

            public void visitNeoStore(NeoStoreRecord record) {
                this.breakStuff();
            }

            public void visitSchemaRule(Collection<DynamicRecord> records) {
                this.breakStuff();
            }

            public void setStartEntry(LogEntry.Start entry) {
                this.breakStuff();
            }

            public void setCommitEntry(LogEntry.Commit entry) {
                this.breakStuff();
            }

            public void complete() {
                this.breakStuff();
            }

            public void visitRelationshipGroup(RelationshipGroupRecord record) {
                this.breakStuff();
            }
        };
    }

    private static class Panic
    implements KernelEventHandler {
        volatile boolean panic = false;

        private Panic() {
        }

        public void beforeShutdown() {
        }

        public Object getResource() {
            return null;
        }

        public void kernelPanic(ErrorState error) {
            this.panic = true;
        }

        public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
            return null;
        }
    }

    private static class BreakageException
    extends RuntimeException {
        public BreakageException() {
            super("Breaking");
        }
    }
}

