/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class DummyIndexExtensionFactory
extends KernelExtensionFactory<Dependencies>
implements IndexImplementation,
Lifecycle {
    public static final String IDENTIFIER = "test-dummy-neo-index";
    public static final String KEY_FAIL_ON_MUTATE = "fail_on_mutate";
    private InternalAbstractGraphDatabase db;
    private IndexProviders indexProviders;

    public DummyIndexExtensionFactory() {
        super(IDENTIFIER);
    }

    public Lifecycle newKernelExtension(Dependencies dependencies) throws Throwable {
        this.db = dependencies.getDatabase();
        this.indexProviders = dependencies.getIndexProviders();
        return this;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.indexProviders.registerIndexProvider(IDENTIFIER, (IndexImplementation)this);
    }

    public void stop() throws Throwable {
        this.indexProviders.unregisterIndexProvider(IDENTIFIER);
    }

    public void shutdown() throws Throwable {
    }

    public String getDataSourceName() {
        return "nioneodb";
    }

    public Index<Node> nodeIndex(String indexName, Map<String, String> config) {
        return new DummyNodeIndex(indexName, this.db, this.failing(config));
    }

    private boolean failing(Map<String, String> config) {
        return Boolean.parseBoolean(config.get(KEY_FAIL_ON_MUTATE));
    }

    public RelationshipIndex relationshipIndex(String indexName, Map<String, String> config) {
        return new DummyRelationshipIndex(indexName, this.db, this.failing(config));
    }

    public Map<String, String> fillInDefaults(Map<String, String> config) {
        return config;
    }

    public boolean configMatches(Map<String, String> storedConfig, Map<String, String> config) {
        return true;
    }

    private static class IteratorIndexHits<T>
    implements IndexHits<T> {
        private final List<T> list;
        private final Iterator<T> iterator;

        IteratorIndexHits(List<T> list) {
            this.list = list;
            this.iterator = list.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }

        public IndexHits<T> iterator() {
            return this;
        }

        public int size() {
            return this.list.size();
        }

        public void close() {
        }

        public T getSingle() {
            return (T)IteratorUtil.singleOrNull((Iterator)((Object)this));
        }

        public float currentScore() {
            return Float.NaN;
        }
    }

    private class DummyRelationshipIndex
    extends DummyIndex<Relationship>
    implements RelationshipIndex {
        public DummyRelationshipIndex(String name, InternalAbstractGraphDatabase db, boolean failing) {
            super(name, db, failing);
        }

        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }

        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            throw new UnsupportedOperationException();
        }

        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            throw new UnsupportedOperationException();
        }

        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            throw new UnsupportedOperationException();
        }
    }

    private class DummyNodeIndex
    extends DummyIndex<Node> {
        public DummyNodeIndex(String name, InternalAbstractGraphDatabase db, boolean failing) {
            super(name, db, failing);
        }

        public Class<Node> getEntityType() {
            return Node.class;
        }
    }

    private abstract class DummyIndex<T extends PropertyContainer>
    implements Index<T> {
        private final String name;
        private final InternalAbstractGraphDatabase db;
        private final boolean failing;

        public DummyIndex(String name, InternalAbstractGraphDatabase db, boolean failing) {
            this.name = name;
            this.db = db;
            this.failing = failing;
        }

        public String getName() {
            return this.name;
        }

        public IndexHits<T> get(String key, Object value) {
            return new IteratorIndexHits(Collections.emptyList());
        }

        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            throw new UnsupportedOperationException();
        }

        public IndexHits<T> query(Object queryOrQueryObject) {
            throw new UnsupportedOperationException();
        }

        public boolean isWriteable() {
            return false;
        }

        public GraphDatabaseService getGraphDatabase() {
            return null;
        }

        public void add(T entity, String key, Object value) {
            this.mutate();
        }

        public void remove(T entity, String key, Object value) {
            this.mutate();
        }

        public void remove(T entity, String key) {
            this.mutate();
        }

        public void remove(T entity) {
            this.mutate();
        }

        public void delete() {
            this.mutate();
        }

        public T putIfAbsent(T entity, String key, Object value) {
            throw new UnsupportedOperationException();
        }

        private void mutate() {
            if (this.failing) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface Dependencies {
        public InternalAbstractGraphDatabase getDatabase();

        public IndexProviders getIndexProviders();
    }
}

