/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TargetDirectory;

public class TestIndexCommand {
    private static final String INDEX_NAME_1 = "persons";
    private static final String INDEX_NAME_2 = "rels";
    private static final long NODE_ID_1 = 10L;
    private static final long NODE_ID_2 = 11L;
    private static final long NODE_ID_3 = 12L;
    private static final long REL_ID_1 = 101L;
    private static final String KEY_1 = "name";
    private static final String KEY_2 = "title";
    private static final String KEY_3 = "type";
    private static final String STRING_VALUE_1 = "Mattias";
    private static final String STRING_VALUE_2 = "Blabla";
    private static final int INT_VALUE = 345;
    private static final Map<String, String> SOME_CONFIG = MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"});
    private final XaCommandWriter writer = new XaCommandWriter(){

        public void write(XaCommand command, LogBuffer buffer) throws IOException {
            if (command instanceof IndexDefineCommand) {
                ((IndexDefineCommand)command).writeToFile(buffer);
            } else if (command instanceof IndexCommand) {
                ((IndexCommand)command).writeToFile(buffer);
            }
        }
    };
    @Rule
    public TargetDirectory.TestDirectory directory = TargetDirectory.forTest(TestIndexCommand.class).testDirectory();

    @Test
    public void testWriteReadTruncate() throws Exception {
        List<XaCommand> commands = this.createSomeCommands();
        Pair<File, List<Long>> writtenCommands = this.writeCommandsToFile(commands);
        List<XaCommand> readCommands = this.readCommandsFromFile((File)writtenCommands.first());
        Iterator<XaCommand> commandIterator = commands.iterator();
        for (XaCommand readCommand : readCommands) {
            Assert.assertEquals((Object)commandIterator.next(), (Object)readCommand);
        }
        for (int i = 0; i < commands.size(); ++i) {
            long startPosition = (Long)((List)writtenCommands.other()).get(i);
            long nextStartPosition = i + 1 < commands.size() ? ((Long)((List)writtenCommands.other()).get(i + 1)).longValue() : ((File)writtenCommands.first()).length();
            for (long p = startPosition; p < nextStartPosition; ++p) {
                File copy = this.copyAndTruncateFile((File)writtenCommands.first(), p);
                List<XaCommand> readTruncatedCommands = this.readCommandsFromFile(copy);
                Assert.assertEquals((long)i, (long)readTruncatedCommands.size());
                FileUtils.deleteFile((File)copy);
            }
        }
        ((File)writtenCommands.first()).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyAndTruncateFile(File file, long fileSize) throws IOException {
        File copy = File.createTempFile("index", "copy", this.directory.directory());
        FileUtils.copyFile((File)file, (File)copy);
        try (RandomAccessFile raFile = new RandomAccessFile(copy, "rw");){
            raFile.getChannel().truncate(fileSize);
        }
        return copy;
    }

    private List<XaCommand> createSomeCommands() {
        ArrayList<XaCommand> commands = new ArrayList<XaCommand>();
        IndexDefineCommand definitions = new IndexDefineCommand();
        commands.add((XaCommand)definitions);
        commands.add((XaCommand)definitions.create(INDEX_NAME_1, Node.class, SOME_CONFIG));
        commands.add((XaCommand)definitions.add(INDEX_NAME_1, Node.class, 10L, KEY_1, (Object)STRING_VALUE_1));
        commands.add((XaCommand)definitions.add(INDEX_NAME_1, Node.class, 10L, KEY_2, (Object)STRING_VALUE_2));
        commands.add((XaCommand)definitions.addRelationship(INDEX_NAME_2, Relationship.class, 101L, KEY_3, (Object)345, 11L, 12L));
        commands.add((XaCommand)definitions.remove(INDEX_NAME_1, Node.class, 11L, KEY_1, (Object)STRING_VALUE_1));
        commands.add((XaCommand)definitions.delete(INDEX_NAME_2, Relationship.class));
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XaCommand> readCommandsFromFile(File file) throws IOException {
        ArrayList<XaCommand> commands;
        FileInputStream in = null;
        FileChannel reader = null;
        try {
            XaCommand command;
            in = new FileInputStream(file);
            reader = in.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(10000);
            commands = new ArrayList<XaCommand>();
            while ((command = IndexCommand.readCommand((ReadableByteChannel)reader, (ByteBuffer)buffer)) != null) {
                commands.add(command);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<File, List<Long>> writeCommandsToFile(List<XaCommand> commands) throws IOException {
        ArrayList<Long> startPositions;
        File file = File.createTempFile("index", "command");
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            StoreFileChannel fileChannel = new StoreFileChannel(randomAccessFile.getChannel());
            DirectMappedLogBuffer writeBuffer = new DirectMappedLogBuffer((StoreChannel)fileChannel, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
            startPositions = new ArrayList<Long>();
            for (XaCommand command : commands) {
                startPositions.add(writeBuffer.getFileChannelPosition());
                this.writer.write(command, (LogBuffer)writeBuffer);
            }
            writeBuffer.force();
            fileChannel.close();
        }
        return Pair.of((Object)file, startPositions);
    }
}

