/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestIndexImplOnNeo {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private GraphDatabaseService db;

    @Before
    public void createDb() throws Exception {
        this.db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase("mydb");
    }

    private void restartDb() throws Exception {
        this.shutdownDb();
        this.createDb();
    }

    @After
    public void shutdownDb() throws Exception {
        this.db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createIndexWithProviderThatUsesNeoAsDataSource() throws Exception {
        Index index;
        String indexName = "inneo";
        Assert.assertFalse((boolean)this.indexExists(indexName));
        Map config = MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index", "config1", "A value", "another config", "Another value"});
        Transaction transaction = this.db.beginTx();
        try {
            index = this.db.index().forNodes(indexName, config);
            transaction.success();
        }
        finally {
            transaction.finish();
        }
        Assert.assertTrue((boolean)this.indexExists(indexName));
        Assert.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
        Assert.assertEquals((long)0L, (long)IteratorUtil.count((Iterable)index.get("key", (Object)"something else")));
        this.restartDb();
        Assert.assertTrue((boolean)this.indexExists(indexName));
        Assert.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean indexExists(String indexName) {
        Transaction transaction = this.db.beginTx();
        try {
            boolean bl = this.db.index().existsForNodes(indexName);
            return bl;
        }
        finally {
            transaction.finish();
        }
    }
}

