/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.io.File;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import javax.transaction.Transaction;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockWorkFailureDump;
import org.neo4j.kernel.impl.locking.LockWorker;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@Ignore(value="Not a test, part of a compatibility suite.")
public class LegacyDeadlockCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public LegacyDeadlockCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    @Ignore
    public void testDeadlockDetection() throws Exception {
        long r1 = 1L;
        long r2 = 2L;
        long r3 = 3L;
        long r4 = 4L;
        LockWorker t1 = new LockWorker("T1", this.locks);
        LockWorker t2 = new LockWorker("T2", this.locks);
        LockWorker t3 = new LockWorker("T3", this.locks);
        LockWorker t4 = new LockWorker("T4", this.locks);
        try {
            t1.getReadLock(r1, true);
            t1.getReadLock(r4, true);
            t2.getReadLock(r2, true);
            t2.getReadLock(r3, true);
            t3.getReadLock(r3, true);
            t3.getWriteLock(r1, false);
            t2.getWriteLock(r4, false);
            t1.getWriteLock(r2, true);
            Assert.assertTrue((boolean)t1.isLastGetLockDeadLock());
            t1.releaseReadLock(r4);
            t1.getWriteLock(r2, false);
            t2.releaseReadLock(r2);
            t1.getWriteLock(r4, false);
            t2.getWriteLock(r2, true);
            Assert.assertTrue((t2.isLastGetLockDeadLock() || t1.isLastGetLockDeadLock() ? 1 : 0) != 0);
            t2.releaseWriteLock(r4);
            t1.releaseWriteLock(r4);
            t2.getReadLock(r4, true);
            t1.releaseWriteLock(r2);
            t1.getReadLock(r2, true);
            t1.releaseReadLock(r1);
            t3.getReadLock(r2, true);
            t3.releaseWriteLock(r1);
            t1.getReadLock(r1, true);
            t1.getWriteLock(r4, false);
            t3.getWriteLock(r1, false);
            t4.getReadLock(r2, true);
            t2.getWriteLock(r2, true);
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseReadLock(r4);
            t1.releaseWriteLock(r4);
            t1.releaseReadLock(r1);
            t2.getReadLock(r4, true);
            t3.releaseWriteLock(r1);
            t1.getReadLock(r1, true);
            t1.getWriteLock(r4, false);
            t3.releaseReadLock(r2);
            t3.getWriteLock(r1, false);
            t2.releaseReadLock(r4);
            t1.releaseWriteLock(r4);
            t1.releaseReadLock(r1);
            t3.releaseWriteLock(r1);
            t1.releaseReadLock(r2);
            t4.releaseReadLock(r2);
            t2.releaseReadLock(r3);
            t3.releaseReadLock(r3);
            t1.getReadLock(r1, true);
            t2.getReadLock(r1, true);
            t1.getWriteLock(r1, false);
            t2.getWriteLock(r1, true);
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseReadLock(r1);
            t1.releaseReadLock(r1);
            t1.releaseWriteLock(r1);
        }
        catch (Exception e) {
            File file = new LockWorkFailureDump(this.getClass()).dumpState(this.locks, t1, t2, t3, t4);
            throw new RuntimeException("Failed, forensics information dumped to " + file.getAbsolutePath(), e);
        }
    }

    @Test
    public void testStressMultipleThreads() throws Exception {
        for (int i = 0; i < StressThread.resources.length; ++i) {
            StressThread.resources[i] = i;
        }
        StressThread[] stressThreads = new StressThread[50];
        CountDownLatch startSignal = new CountDownLatch(1);
        for (int i = 0; i < stressThreads.length; ++i) {
            int numberOfIterations = 100;
            int depthCount = 10;
            float readWriteRatio = 0.8f;
            stressThreads[i] = new StressThread("T" + i, numberOfIterations, depthCount, readWriteRatio, this.locks.newClient(), startSignal);
        }
        for (StressThread thread : stressThreads) {
            thread.start();
        }
        startSignal.countDown();
        while (this.anyAliveAndAllWell(stressThreads)) {
            this.throwErrorsIfAny(stressThreads);
            this.sleepALittle();
        }
    }

    private String diagnostics(StressThread culprit, StressThread[] stressThreads, long waited) {
        StringBuilder builder = new StringBuilder();
        for (StressThread stressThread : stressThreads) {
            if (stressThread.isAlive()) {
                if (stressThread == culprit) {
                    builder.append("This is the thread that waited too long. It waited: ").append(waited).append(" milliseconds");
                }
                for (StackTraceElement element : stressThread.getStackTrace()) {
                    builder.append(element.toString()).append("\n");
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private void throwErrorsIfAny(StressThread[] stressThreads) throws Exception {
        for (StressThread stressThread : stressThreads) {
            if (stressThread.error == null) continue;
            throw stressThread.error;
        }
    }

    private void sleepALittle() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private boolean anyAliveAndAllWell(StressThread[] stressThreads) {
        for (StressThread stressThread : stressThreads) {
            long waitingTime;
            if (!stressThread.isAlive()) continue;
            Long startedWaiting = stressThread.startedWaiting;
            if (startedWaiting != null && (waitingTime = System.currentTimeMillis() - startedWaiting) > 5000L) {
                Assert.fail((String)("One of the threads waited far too long. Diagnostics: \n" + this.diagnostics(stressThread, stressThreads, waitingTime)));
            }
            return true;
        }
        return false;
    }

    public static class StressThread
    extends Thread {
        private static final Object READ = new Object();
        private static final Object WRITE = new Object();
        private static long[] resources = new long[10];
        private final Random rand = new Random(System.currentTimeMillis());
        private final CountDownLatch startSignal;
        private final String name;
        private final int numberOfIterations;
        private final int depthCount;
        private final float readWriteRatio;
        private final Locks.Client lm;
        private volatile Exception error;
        private final Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        public volatile Long startedWaiting = null;

        StressThread(String name, int numberOfIterations, int depthCount, float readWriteRatio, Locks.Client lm, CountDownLatch startSignal) {
            this.name = name;
            this.numberOfIterations = numberOfIterations;
            this.depthCount = depthCount;
            this.readWriteRatio = readWriteRatio;
            this.lm = lm;
            this.startSignal = startSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startSignal.await();
                Stack<Object> lockStack = new Stack<Object>();
                Stack<Long> resourceStack = new Stack<Long>();
                for (int i = 0; i < this.numberOfIterations; ++i) {
                    try {
                        int depth = this.depthCount;
                        do {
                            float f = this.rand.nextFloat();
                            int n = this.rand.nextInt(resources.length);
                            if (f < this.readWriteRatio) {
                                this.startedWaiting = System.currentTimeMillis();
                                this.lm.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{resources[n]});
                                this.startedWaiting = null;
                                lockStack.push(READ);
                            } else {
                                this.startedWaiting = System.currentTimeMillis();
                                this.lm.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{resources[n]});
                                this.startedWaiting = null;
                                lockStack.push(WRITE);
                            }
                            resourceStack.push(resources[n]);
                        } while (--depth > 0);
                        continue;
                    }
                    catch (DeadlockDetectedException e) {
                        continue;
                    }
                    finally {
                        this.releaseAllLocks(lockStack, resourceStack);
                    }
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        private void releaseAllLocks(Stack<Object> lockStack, Stack<Long> resourceStack) {
            while (!lockStack.isEmpty()) {
                if (lockStack.pop() == READ) {
                    this.lm.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{resourceStack.pop()});
                    continue;
                }
                this.lm.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{resourceStack.pop()});
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        static {
            for (int i = 0; i < resources.length; ++i) {
                StressThread.resources[i] = i;
            }
        }
    }
}

