/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import javax.transaction.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;

public class RWLockLeakTest {
    @Test
    public void assertWriteLockDoesNotLeakMemory() throws InterruptedException {
        RagManager ragManager = new RagManager();
        Object resource = new Object();
        RWLock lock = new RWLock(resource, ragManager);
        Transaction tx1 = (Transaction)Mockito.mock(Transaction.class);
        lock.mark();
        lock.acquireWriteLock(tx1);
        lock.mark();
        Assert.assertEquals((Object)1, (Object)lock.getTxLockElementCount());
        lock.releaseWriteLock(tx1);
        Assert.assertEquals((Object)0, (Object)lock.getTxLockElementCount());
    }

    @Test
    public void assertReadLockDoesNotLeakMemory() throws InterruptedException {
        RagManager ragManager = new RagManager();
        Object resource = new Object();
        RWLock lock = new RWLock(resource, ragManager);
        Transaction tx1 = (Transaction)Mockito.mock(Transaction.class);
        lock.mark();
        lock.acquireReadLock(tx1);
        lock.mark();
        Assert.assertEquals((Object)1, (Object)lock.getTxLockElementCount());
        lock.releaseReadLock(tx1);
        Assert.assertEquals((Object)0, (Object)lock.getTxLockElementCount());
    }
}

