/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class AbstractDynamicStoreTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final File fileName = new File("store");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecognizeDesignatedInUseBit() throws Exception {
        try (AbstractDynamicStore store = this.newTestableDynamicStore();){
            byte otherBitsInTheInUseByte = 0;
            for (int i = 0; i < 8; ++i) {
                this.assertRecognizesByteAsInUse(store, otherBitsInTheInUseByte);
                otherBitsInTheInUseByte = (byte)(otherBitsInTheInUseByte << 1);
                otherBitsInTheInUseByte = (byte)(otherBitsInTheInUseByte | 1);
            }
        }
    }

    private void assertRecognizesByteAsInUse(AbstractDynamicStore store, byte inUseByte) {
        Assert.assertTrue((boolean)store.isRecordInUse(ByteBuffer.wrap(new byte[]{(byte)(inUseByte | 0x10)})));
        Assert.assertFalse((boolean)store.isRecordInUse(ByteBuffer.wrap(new byte[]{(byte)(inUseByte & 0xFFFFFFEF)})));
    }

    private AbstractDynamicStore newTestableDynamicStore() {
        return new AbstractDynamicStore(this.fileName, new Config(), IdType.ARRAY_BLOCK, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (WindowPoolFactory)new DefaultWindowPoolFactory(), this.fsr.get(), StringLogger.DEV_NULL, StoreVersionMismatchHandler.ACCEPT){

            public void accept(RecordStore.Processor processor, DynamicRecord record) {
            }

            public String getTypeDescriptor() {
                return "TestDynamicStore";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void before() throws IOException {
        try (StoreChannel channel = this.fsr.get().create(this.fileName);){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(60);
            buffer.flip();
            channel.write(buffer);
        }
    }
}

