/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.AbstractPersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;

public class AbstractPersistenceWindowTests {
    private static final Random RANDOM = new Random();
    private static final int RECORD_SIZE = 7;
    private static final int NUMBER_OF_RECORDS = 13;
    private AbstractPersistenceWindow window;

    @Before
    public void before() throws Exception {
        File directory = new File("target/test-data");
        directory.mkdirs();
        String filename = new File(directory, UUID.randomUUID().toString()).getAbsolutePath();
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        StoreFileChannel channel = new StoreFileChannel(file.getChannel());
        this.window = new AbstractPersistenceWindow(0L, 7, 91, (StoreChannel)channel, ByteBuffer.allocate(91)){};
    }

    @Test
    public void shouldNotLetChangesToOffsetInterfereWithFlushing() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    AbstractPersistenceWindowTests.this.window.getBuffer().setOffset(RANDOM.nextInt(AbstractPersistenceWindowTests.this.window.getBuffer().getBuffer().limit()));
                }
            }
        }).start();
        try {
            for (int i = 1; i < 10000; ++i) {
                this.window.force();
            }
        }
        catch (BufferOverflowException e) {
            Assert.fail((String)"Changing the state of the buffer's flags should not affect flushing");
        }
    }

    @Test
    public void shouldNotLetFlushingInterfereWithReads() throws Exception {
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.getBuffer().get();
        this.window.force();
        try {
            this.window.getBuffer().get();
        }
        catch (BufferUnderflowException e) {
            Assert.fail((String)"Flushing should not affect the state of the buffer's flags");
        }
    }
}

